(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     93805,       2640]*)
(*NotebookOutlinePosition[     94526,       2665]*)
(*  CellTagsIndexPosition[     94482,       2661]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Pr\[AAcute]ctica 3\nAyudando a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " a resolver ecuaciones diferenciales ordinarias."
}], "Title"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "En esta pr\[AAcute]ctica te voy a proponer que hagas algunos ejercicios de \
resoluci\[OAcute]n de EDs sencillas con ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Como hemos comentado en el curso, son pocas las EDs que pueden \
resolverse, de forma m\[AAcute]s o menos expl\[IAcute]cita, calculando \
primitivas. Algunos tipos de EDs para los que esto es posible son las EDs de \
variables separadas, las EDs exactas y las que pueden reducirse a ellas como, \
por ejemplo, la EDO lineal de orden 1 o las EDs homog\[EAcute]neas. Adem\
\[AAcute]s de estos tipos b\[AAcute]sicos, hay una gran variedad de EDs cuya \
soluci\[OAcute]n puede calcularse con t\[EAcute]cnicas espec\[IAcute]ficas de \
cada caso. Por ejemplo, las EDs de Bernouilli, de Claireaut, de Ricatti y \
otras muchas. Saber usar en cada ocasi\[OAcute]n el recurso adecuado que nos \
lleve a la soluci\[OAcute]n buscada solamente se aprende con la \
pr\[AAcute]ctica y, como no se trata de aplicar una teor\[IAcute]a sistem\
\[AAcute]tica sino una colecci\[OAcute]n de t\[EAcute]cnicas muy variadas, es \
algo que se olvida con facilidad. Hay una excepci\[OAcute]n que es el caso de \
las EDs lineales y de los sistemas de EDs lineales con coeficientes \
constantes para los que hay una teor\[IAcute]a elaborada que permite, al \
menos en teor\[IAcute]a, obtener de forma expl\[IAcute]cita sus soluciones.\n\
El prop\[OAcute]sito de esta pr\[AAcute]ctica es el siguiente. Se trata de \
que resuelvas algunas EDs con la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Te voy a proponer algunos ejercicios de resoluci\[OAcute]n de EDs en los \
que t\[UAcute] deber\[AAcute]s reconocer el tipo de ED de que se trata en \
cada caso y pedirle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que realice las operaciones oportunas para obtener la soluci\[OAcute]n. \
Claro est\[AAcute] que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " dispone de un comando que resuelve muchas EDO de los tipos usuales, este \
comando es DSolve[ ] y est\[AAcute] bien documentado en la ayuda del \
programa. Pero no debes usar este comando para realizar los ejercicios; en \
todo caso puedes usarlo para comprobar la soluci\[OAcute]n que has obtenido. \
Es decir, se trata de que t\[UAcute] indiques a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " el procedimiento a seguir y pedirle al programa que haga el \"trabajo \
sucio\". De esta forma puedes centrarte en el procedimiento y comprobar su \
eficacia y puedes descuidarte de c\[AAcute]lculos que suelen ser largos. En \
definitiva, se trata de que t\[UAcute] pongas el ",
  StyleBox["cerebro pensante",
    FontSlant->"Italic"],
  " y ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la ",
  StyleBox["fuerza bruta",
    FontSlant->"Italic"],
  ". A continuaci\[OAcute]n desarrollo algunos ejemplos para que te sirvan de \
orientaci\[OAcute]n de lo que pretendo que hagas en esta pr\[AAcute]ctica.\n\
",
  StyleBox["Advertencia importante. Esta pr\[AAcute]ctica debe hacerse con ",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["Mathematica",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" 5.1 o posterior.",
    FontColor->RGBColor[1, 0, 0]]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Din\[AAcute]mica de poblaciones", "Section"],

Cell[CellGroupData[{

Cell["La ecuaci\[OAcute]n log\[IAcute]stica", "Subsection"],

Cell[TextData[{
  "En los llamados procesos de ",
  StyleBox["crecimiento",
    FontSlant->"Italic"],
  " ",
  StyleBox["o decrecimento exponencial",
    FontSlant->"Italic"],
  " (o maltusiano) se supone que el crecimiento de una poblaci\[OAcute]n es \
proporcional al n\[UAcute]mero de individuos. Si representamos por ",
  Cell[BoxData[
      \(TraditionalForm\`y(t)\)]],
  " el n\[UAcute]mero de individuos de la poblaci\[OAcute]n en el tiempo ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", se supone que ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) = \[Alpha]\ \(y(t)\)\)]],
  " donde \[Alpha] es una constante llamada ",
  StyleBox["tasa relativa de crecimiento",
    FontSlant->"Italic"],
  ". La soluci\[OAcute]n de esta sencilla ED es ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y(t)\), "=", 
          
          RowBox[{\(y\_0\), \(\[ExponentialE]\^\(\[Alpha]\ t\)\), " ", 
            "donde", " ", \(y\_0\), " ", "es", " ", "el", " ", "valor", " ", 
            "inicial", " ", Cell[TextData[Cell[BoxData[
                \(TraditionalForm\`\(\(y(0)\)\(.\)\(\ \)\)\)]]]]}]}], 
        TraditionalForm]]],
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] > 0\)]],
  " la poblaci\[OAcute]n crecer\[AAcute] exponencialmente y si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] < 0\)]],
  " decrecer\[AAcute] exponencialmente. En condiciones ideales este modelo se \
ajusta, al menos durante cortos per\[IAcute]dos de tiempo, al estudio de \
algunas poblaciones. Pero es claro que el modelo no puede ser v\[AAcute]lido \
fuera de esas condiciones ideales y deben tenerse en cuenta factores \
limitativos del crecimiento que depender\[AAcute]n de los recursos \
disponibles, depredadores y otras circunstancias que habr\[AAcute] que \
considerar en cada caso. Una hip\[OAcute]tesis m\[AAcute]s real consiste en \
suponer que la tasa de crecimiento relativa no es constante sino que depende \
del n\[UAcute]mero de individuos. Esto lleva a la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) = \(y(t)\)\ \(h(y)\)\)]],
  ". Es razonable suponer que",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(h(y) \[TildeEqual] \[Alpha] > 0\)\)\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " es peque\[NTilde]o (lo que implica que ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) > 0\)]],
  " y la poblaci\[OAcute]n aumenta) y que ",
  Cell[BoxData[
      \(TraditionalForm\`h(y) < 0\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " es grande (lo que implica que ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) < 0\)]],
  " y la poblaci\[OAcute]n disminuye). La funci\[OAcute]n m\[AAcute]s simple \
que cumple estos requisitos es ",
  Cell[BoxData[
      \(TraditionalForm\`h(t) = \[Alpha] - \[Lambda]\ y\)]],
  ". Resulta as\[IAcute] la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) = \(\(y(
              t)\) \((\[Alpha] - \[Lambda]\ \(y(t)\))\) = \[Alpha]\ \(y(
              t)\) \((1 - \[Beta]\ \(y(t)\))\)\)\)]],
  " llamada ",
  StyleBox["ecuaci\[OAcute]n log\[IAcute]stica",
    FontSlant->"Italic"],
  ". La constante ",
  Cell[BoxData[
      \(TraditionalForm\`k = 1/\[Beta]\)]],
  " representa un valor llamado ",
  StyleBox["capacidad de contencion",
    FontSlant->"Italic"],
  " de la poblaci\[OAcute]n. Esta ecuaci\[OAcute]n suele escribirse en la \
forma:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`y' \((t)\) = \[Alpha]\ \(y(
          t)\) \((1 - \ \(y(t)\)\/k)\)\)], "NumberedEquation",
  TextAlignment->Center,
  FormatType->StandardForm],

Cell[TextData[{
  "Busquemos soluciones constantes, ",
  Cell[BoxData[
      \(TraditionalForm\`y = c\)]],
  " de dicha ED. Para ello debe verficarse que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\ c\ \((1 - c/k)\) = 0\)]],
  " lo que proporciona ",
  Cell[BoxData[
      \(TraditionalForm\`c = 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`c = k\)]],
  " . Las soluciones ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0, \ y = k\)]],
  " se llaman ",
  StyleBox["soluciones de equilibrio",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " pues para dichos valores no se produce cambio en la poblaci\[OAcute]n. \
Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) > 0\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`0 < y(t) < k\)]],
  " (la poblaci\[OAcute]n crece) y que ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) < 0\)]],
  " cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y(t) > k\)]],
  " (la poblaci\[OAcute]n decrece). \nPara calcular la soluci\[OAcute]n con \
valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = y\_0\)]],
  " observamos que se trata de una ED de variables separadas pues puede \
escribirse supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`y(t) \[NotEqual] 0, \ y(t) \[NotEqual] k\)]],
  ", como"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[DifferentialD]y\/\(y(1 - \ y/k)\) = \[Alpha]\ \
\[DifferentialD]\ t\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Ahora ponemos a trabajar a ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "y le pedimos que haga lo que nosotros har\[IAcute]amos para resolver esta \
ED. A saber, calcular las correspondientes primitivas, introducir una \
constante y tratar de expresar ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " como funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  " (lo que no siempre podr\[AAcute] hacerse). Calculamos despu\[EAcute]s el \
valor de la constante ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " por la condici\[OAcute]n de que para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " se obtenga un valor inicial dado por ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = p\)]],
  ". Se sustituye el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " obtenido y recuperamos la soluci\[OAcute]n como funci\[OAcute]n de todos \
los par\[AAcute]metros que aparecen en ella, ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha], \ k, \ p\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", pues de esta forma podremos estudiar la dependencia de la \
soluci\[OAcute]n respecto de dichos par\[AAcute]metros."
}], "Text"],

Cell[BoxData[{
    \(sol[t_] = 
      y /. \(Solve[Integrate[1\/\(y \((1 - \ y/k)\)\), y] == \[Alpha]\ t + c, 
              y]\)[\([1]\)] // Simplify\), "\n", 
    \(Off[Solve::"\<ifun\>"]\), "\[IndentingNewLine]", 
    \(\(c /. \(Solve[sol[0] \[Equal] p, c]\)[\([1]\)];\)\), "\n", 
    \(\(y[\[Alpha]_, k_, p_]\)[t_] = 
      sol[t] /. c \[Rule] % // Simplify\), "\[IndentingNewLine]", 
    \(On[Solve::"\<ifun\>"]\)}], "Input"],

Cell[TextData[{
  "Observa que el denominador de esta expresi\[OAcute]n es siempre positivo \
porque suponemos que \[Alpha], \[Beta], y ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " son n\[UAcute]meros positivos, por lo que la soluci\[OAcute]n obtenida \
est\[AAcute] definida en todo ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[DoubleStruckCapitalR]\^+\)\(.\)\)\)]],
  " Comprobamos que los c\[AAcute]lculos fectuados son correctos."
}], "Text"],

Cell[BoxData[
    \({\(y[\[Alpha], k, y\_0]\)[0] (*\ 
        valor\ inicial\ de\ la\ poblaci\[OAcute]n\ *) , \
\[IndentingNewLine]Simplify[
        D[\(y[\[Alpha], k, p]\)[t], 
            t] \[Equal] \[Alpha]\ \(y[\[Alpha], k, p]\)[
              t] \((1 - \(\(\ \)\(\(y[\[Alpha], k, p]\)[t]\)\)\/k)\)] (*\ 
        comprobamos\ que\ es\ soluci\[OAcute]nde\ la\ ED\ *) }\)], "Input"],

Cell[TextData[{
  "Comprobamos ahora las soluciones de equilibrio ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0, \ y = k\)]],
  "."
}], "Text"],

Cell[BoxData[
    \({\(y[\[Alpha], k, 0]\)[t] (*\ 
        y = 0\ es\ una\ soluci\[OAcute]n\ de\ equilibrio\ *) , \n\
\(y[\[Alpha], k, k]\)[t] // Simplify (*\ 
        y = k\ es\ una\ soluci\[OAcute]n\ de\ equilibrio\ *) }\)], "Input"],

Cell[TextData[{
  "Aunque ambas son soluciones de equilibrio porque dan lugar a una poblaci\
\[OAcute]n constante en el tiempo, la situaci\[OAcute]n de equilibrio que \
reflejan es de muy distinta naturaleza. Podemos estudiar el comportamiento de \
la poblaci\[OAcute]n para valores muy grandes de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ". En el siguiente c\[AAcute]lculo es obligado informar a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " de que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " son positivos. "
}], "Text"],

Cell[BoxData[
    \(Limit[\(y[\[Alpha], k, p]\)[t], t \[Rule] \(+\[Infinity]\), 
      Assumptions \[Rule] \[Alpha] > 0 && p > 0]\)], "Input"],

Cell[TextData[{
  "Esto nos dice que la poblaci\[OAcute]n tiende a estabilizarse en torno a \
la soluci\[OAcute]n de equilibrio ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  ". Ve\[AAcute]moslo gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[
    \(\(\(\(\(Plot[\(y[ .2, 1000, 20]\)[t], {t, 0, 50}]\) \);\)\( (*\ 
      Aunque\ partimos\ de\ un\ valor\ inicial\ peque\[NTilde]o\ y\_0 = \(20 \
< k = \(1000\ la\ poblaci\[OAcute]n\ crece\ acerc\[AAcute]ndose\ al\ valor\ k \
= 1000\)\)\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(\(Plot[\(y[ .2, 1000, 1010]\)[t], {t, 0, 50}]\) \);\)\( (*\ 
      Ahora\ partimos\ de\ un\ valor\ mayor\ que\ k, \ 
      y\_0 = \(1010 > k = 1000\), \ 
      y\ la\ poblaci\[OAcute]n\ decrece\ acerc\[AAcute]ndose\ al\ valor\ k = 
        1000\ \ *) \)\)\)], "Input"],

Cell[TextData[{
  "La siguiente gr\[AAcute]fica muestra el comportamiento de las soluciones \
cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] =  .2, \ k = 1000\)]],
  " para distintos valores de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[
        Table[Plot[\(y[ .2, 1000, p]\)[t], {t, 0, 30}, 
            PlotRange -> {{0, 30}, {0, 1200}}, 
            DisplayFunction -> Identity], {p, 50, 1900, 50}], 
        DisplayFunction -> $DisplayFunction];\)\)], "Input"],

Cell[TextData[{
  "Vemos que las soluciones con un valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`p > 0\)]],
  " se alejan de la soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " por lo que se dice que ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " es una soluci\[OAcute]n de ",
  StyleBox["equilibrio inestable",
    FontSlant->"Italic"],
  ". Vemos tambi\[EAcute]n que las soluciones con un valor inicial ",
  Cell[BoxData[
      \(TraditionalForm\`p > 0\)]],
  " se aproximan de la soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  " por lo que se dice que ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  " es una soluci\[OAcute]n de ",
  StyleBox["equilibrio asint\[OAcute]ticamente estable",
    FontSlant->"Italic"],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Modelo poblacional con un umbral cr\[IAcute]tico", "Subsection"],

Cell[TextData[{
  "Si en la ecuaci\[OAcute]n log\[IAcute]stica (1) suponemos que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] < 0\)]],
  " entonces el comportamiento de las soluciones es muy diferente y el modelo \
se ajusta a una situaci\[OAcute]n en la que por debajo de un cierto valor l\
\[IAcute]mite, que viene dado por la constante ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ", la poblaci\[OAcute]n se extingue, y por encima de dicho valor la poblaci\
\[OAcute]n crece indefinidamente. El valor de",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(k\)\)\)]],
  " es el ",
  StyleBox["umbral de supervivencia",
    FontSlant->"Italic"],
  " de la especie."
}], "Text"],

Cell[BoxData[
    \(\(y[\(-\[Alpha]\), k, p]\)[t] // Simplify\)], "Input"],

Cell[TextData[{
  "El denominador de esta expresi\[OAcute]n no se anula nunca si ",
  Cell[BoxData[
      \(TraditionalForm\`p < k\)]],
  " en cuyo caso la poblaci\[OAcute]n se extingue r\[AAcute]pidamente debido \
a la presencia de la exponencial positiva en el denominador. Podemos verlo gr\
\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[
    \(\(\(Plot[\(y[\(- .2\), 1000, 990]\)[t], {t, 0, 
          50}];\)\( (*\ \[Alpha] = \(- .2\), 
      y\_0 = \(990 < k = 1000\)\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`p > k\)]],
  " el denominador se anula en un punto dado por:"
}], "Text"],

Cell[BoxData[
    \(\[Lambda][\[Alpha]_, k_, p_] = 
      t /. \(Solve[\[ExponentialE]\^\(t\ \[Alpha]\)\ \((k - p)\) + p \[Equal] 
              0, t]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "En este caso la soluci\[OAcute]n solamente tiene sentido en el intervalo",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\([0, \[Lambda][\[Alpha], k, z]]\)\)\)]],
  " y tiene una as\[IAcute]ntota vertical en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda][\[Alpha], k, z]\)]],
  " lo que indica que la poblaci\[OAcute]n crecer\[AAcute] sin \
l\[IAcute]mite. Podemos verlo gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[
    \(\(\(\(\(Plot[\(y[\(- .2\), 1000, 1010]\)[t], {t, 
            0, \[Lambda][ .2, 1000, 
                1010] -  .2}]\) \);\)\( (*\ \[Alpha] = \(- .2\), \ 
      y\_0 = \(1010 > k = 1000\)\ *) \)\)\)], "Input"],

Cell[TextData[{
  "Observa que las soluciones de equilibrio siguen siendo las mismas que \
antes (no dependen de ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\)]],
  ") pero ahora ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " es asint\[OAcute]ticamente estable, mientras que ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  " es inestable."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimizaci\[OAcute]n de recursos perecederos", "Subsection"],

Cell["\<\
Supongamos una especie que, en su medio natural, responde al modelo log\
\[IAcute]stico (1), sufre p\[EAcute]rdidas sistem\[AAcute]ticas por capturas. \
Podemos considerar que se trata de una poblaci\[OAcute]n de peces cuyas p\
\[EAcute]rdidas son debidas a la actividad pesquera en la zona que habitan. \
Naturalmente, los pescadores quieren pescar cuanto m\[AAcute]s mejor, pero \
saben que si se exceden ponen en peligro la supervivencia del banco de pesca. \
Un modelo para esta poblaci\[OAcute]n suponiendo que se pesca semanalmente un \
n\[UAcute]mero fijo de peces est\[AAcute] dado por la siguiente ED.\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`y' \((t)\) = \[Alpha]\ \(y(
            t)\) \((1 - \ \(y(t)\)\/k)\) - c\)], "NumberedEquation",
  TextAlignment->Center,
  FormatType->StandardForm],

Cell[TextData[{
  "Donde la constante ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  " es el n\[UAcute]mero de peces que se pescan semanalmente. Se trata de una \
peque\[NTilde]a modificaci\[OAcute]n de la ecuaci\[OAcute]n \
log\[IAcute]stica. Observa que la ED (2) sigue siendo una ED de variables \
separadas porque podemos escribirla en la forma:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[DifferentialD]y\/\(y\ \((1 - \ \[Beta]\ y)\) - c/\
\[Alpha]\) = \[Alpha]\ \[DifferentialD]\ t\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Donde hemos puesto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Beta] = 1/k\)]],
  ". ",
  "Intentemos proceder igual que antes."
}], "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\n", 
    \(sol[t_] = 
      y /. \(Solve[
              Integrate[1\/\(y \((1 - \ \[Beta]\ y)\) - c/\[Alpha]\), 
                  y] == \[Alpha]\ t + m, y]\)[\([1]\)] // 
        Simplify\), "\[IndentingNewLine]", 
    \(\(m /. \(Solve[sol[0] \[Equal] p, m]\)[\([1]\)];\)\), "\n", 
    \(\(y[\[Alpha]_, \[Beta]_, c_, p_]\)[t_] = 
      sol[t] /. m \[Rule] % // Simplify\)}], "Input"],

Cell[TextData[{
  "Veremos que la advertencia de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " est\[AAcute] justificada. Seguidamente, calculamos las soluciones de \
equilibrio y simplificamos el resultado obtenido. "
}], "Text"],

Cell[BoxData[{
    \(\(y /. 
        Solve[y \((1 - \ \[Beta]\ y)\) - c/\[Alpha] \[Equal] 0, 
          y];\)\), "\[IndentingNewLine]", 
    \(soleq[\[Alpha]_, \[Beta]_, c_] = 
      Simplify[%, \[Alpha] > 0] /. \@\(x_*y_\) -> \(\@x\) \@y\)}], "Input"],

Cell[TextData[{
  "Ahora dichas soluciones dependen de todos los par\[AAcute]metros y \
solamente tienen sentido para el caso de que sean reales, es decir, cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] - 4\ c\ \[Beta] \[GreaterEqual] 0\)]],
  ". Observa que la soluci\[OAcute]n que ha calculado ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "viene dada por la funci\[OAcute]n tangente. Si reflexionas un poco, caer\
\[AAcute]s en la cuenta de que el resultado debe estar muy simplificado pues \
la primitiva de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`1\/\(y\ \((1 - \ \[Beta]\ y)\) - c/\[Alpha]\)\)],
    TextAlignment->Center],
  " depende de que las ra\[IAcute]ces del denominador sean reales o \
complejas. Dichas ra\[IAcute]ces son justamente las soluciones de equilibrio \
que acabamos de calcular. Cuando son reales, la fracci\[OAcute]n anterior se \
descompone en dos fracciones de la forma siguiente. "
}], "Text"],

Cell[BoxData[
    \(Apart[1\/\(\[Alpha]*\[Beta] \((y - \[Lambda])\)*\((y - \[Mu])\)\), 
      y]\)], "Input"],

Cell[TextData[{
  "Las primitivas correspondientes son logaritmos y, al despejar ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " en funci\[OAcute]n de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ", debemos esperar que se obtengan exponenciales. Aparentemente, en la \
soluci\[OAcute]n obtenida por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " no hay exponenciales; pero, aunque no se muestren, est\[AAcute]n ah\
\[IAcute] escondidas. Recuerda que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " trabaja siempre con n\[UAcute]meros complejos y las funciones usuales est\
\[AAcute]n definidas para trabajar por defecto con n\[UAcute]meros complejos. \
La funci\[OAcute]n Tan[ ] no es una excepci\[OAcute]n y las funciones \
trigonom\[EAcute]tricas est\[AAcute]n relacionadas con la exponencial \
compleja. Aqu\[IAcute] est\[AAcute]n las exponenciales que no vemos."
}], "Text"],

Cell[BoxData[
    \(TrigToExp[Tan[z]]\)], "Input"],

Cell[TextData[{
  "Vamos a tratar de simplificar todo lo que se pueda la soluci\[OAcute]n \
obtenida para el caso en que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] - 4  c\ b > 0\)]],
  " (ra\[IAcute]ces reales) y para el caso en que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] - 4  c\ \[Beta] < 0\)]],
  " (ra\[IAcute]ces complejas). El caso en que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] - 4\ c\ \[Beta] = 0\)]],
  " (una ra\[IAcute]z real doble) hay que tratarlo aparte. Pedimos a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que simplifique d\[AAcute]ndole toda la informaci\[OAcute]n posible."
}], "Text"],

Cell[BoxData[
    \(Simplify[\(y[\[Alpha], \[Beta], c, p]\)[t], 
      t > 0 && \[Alpha] > 0 && \[Beta] > 0 && c > 0 && 
        p > 0 && \(-\[Alpha]\) + 4\ c\ \[Beta] < 0]\)], "Input"],

Cell[TextData[{
  "Observa que ya no figura la funci\[OAcute]n Tan[ ] sino Tanh[ ], y la \
tangente hiperb\[OAcute]lica se define mediante exponenciales reales. Para \
que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " simplifique m\[AAcute]s tenemos que decirle lo que queremos que haga."
}], "Text"],

Cell[BoxData[{
    \(\(\(% /. 
          Tanh[x_ + 
                y_] \[Rule] \((Tanh[x] + Tanh[y])\)/\((1 + 
                  Tanh[x] Tanh[y])\)\) /. 
        Tanh[ArcTanh[z_]] \[Rule] z;\)\[IndentingNewLine] (*\ 
      Ahora\ sustituimos\ la\ tangente\ hiperb\[OAcute]lica\ por\ \
exponenciales\ y\ simplificamos\ *) \), "\[IndentingNewLine]", 
    \(% /. Tanh[x_] \[Rule] \((Exp[2  x] - 1)\)/\((Exp[2  x] + 1)\) // 
      Simplify\)}], "Input"],

Cell["\<\
Ya no puede simplificarse m\[AAcute]s. Definimos la soluci\[OAcute]n obtenida \
para el caso de ra\[IAcute]ces reales.\
\>", "Text"],

Cell[BoxData[
    \(\(yreal[\[Alpha]_, \[Beta]_, c_, p_]\)[
        t_] := \(\@\[Alpha] + \(\@\(\[Alpha] - 4\ c\ \[Beta]\)\ \((\(-1\) + 2\
\ p\ \[Beta] - \@\(1 - \(4\ c\ \[Beta]\)\/\[Alpha]\) + \[ExponentialE]\^\(t\ \
\@\(\[Alpha]\ \((\[Alpha] - 4\ c\ \[Beta])\)\)\)\ \((\(-1\) + 2\ p\ \[Beta] + \
\@\(1 - \(4\ c\ \[Beta]\)\/\[Alpha]\))\))\)\)\/\(1 - 2\ p\ \[Beta] + \@\(1 - \
\(4\ c\ \[Beta]\)\/\[Alpha]\) + \[ExponentialE]\^\(t\ \@\(\[Alpha]\ \((\
\[Alpha] - 4\ c\ \[Beta])\)\)\)\ \((\(-1\) + 2\ p\ \[Beta] + \@\(1 - \(4\ c\ \
\[Beta]\)\/\[Alpha]\))\)\)\)\/\(2\ \@\[Alpha]\ \[Beta]\) /; \((\[Alpha] - 
                4\ c\ \[Beta] > \ 0 || 
            c < \ \[Alpha]\/\(4\ \[Beta]\))\)\)], "Input"],

Cell[TextData[{
  "Observa que la soluci\[OAcute]n proporcionada por ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " para el caso en que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 4\ c\ \[Beta]\)]],
  " es ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\)\(=\)\(1\/\(2  \[Beta]\)\)\(\ \)\)\)]],
  " que es la soluci\[OAcute]n de equilibrio corrrespondiente."
}], "Text"],

Cell[BoxData[
    \(sol[t] /. {c \[Rule] \[Alpha]\/\(4  \[Beta]\)} // Simplify\)], "Input"],

Cell[TextData[{
  "Debemos, pues, considerar aparte la ED que corresponde al caso ",
  Cell[BoxData[
      \(TraditionalForm\`c = \[Alpha]\/\(4\ \[Beta]\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(Simplify[\[Alpha]\ y \((1 - \[Beta]\ y)\) - \[Alpha]\/\(4\ \
\[Beta]\)]\)], "Input"],

Cell[TextData[{
  "Se trata, pues, de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y'\  = \ \(\(-\[Alpha]\)\(\ \)\(\((1 - 2  y\ \
\[Beta])\)\^2/4\) \(\[Beta]\)\(\ \)\)\)]],
  ". Calculemos la soluci\[OAcute]n que verifica ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = p\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(sol[t_] = 
      y /. \(Solve[
              Integrate[1\/\((1 - 2\ y\ \[Beta])\)\^2, 
                  y] \[Equal] \(-\(\[Alpha]\/\(4  \[Beta]\)\)\)\ t + m, 
              y]\)[\([1]\)] // Simplify\), "\[IndentingNewLine]", 
    \(\(m /. \(Solve[sol[0] \[Equal] p, m]\)[\([1]\)];\)\), "\n", 
    \(\(yreal2[\[Alpha]_, \[Beta]_, p_]\)[t_] = 
      sol[t] /. m \[Rule] % // Simplify\), "\[IndentingNewLine]", 
    \(Clear[sol]\)}], "Input"],

Cell["\<\
Consideremos ahora el caso de ra\[IAcute]ces complejas. Intentemos \
simplificar.\
\>", "Text"],

Cell[BoxData[
    \(Simplify[\(y[\[Alpha], \[Beta], c, p]\)[t], 
      t > 0 && \[Alpha] > 0 && \[Beta] > 0 && c > 0 && 
        p > 0 && \(-\[Alpha]\) + 4\ c\ \[Beta] > 0]\)], "Input"],

Cell["\<\
Como era de esperar, no hemos logrado nada. Debemos hacerlo nosotros.\
\>", "Text"],

Cell[BoxData[{
    \(\(\(% /. 
          Tan[x_ + 
                y_] \[Rule] \((Tan[x] + Tan[y])\)/\((1 - Tan[x] Tan[y])\)\) /. 
        Tan[ArcTan[u_]] \[Rule] u;\)\), "\[IndentingNewLine]", 
    \(\(% /. 
        Tan[w_] \[Rule] \(-I\)*\((Exp[2  I\ w] - 1)\)/\((Exp[2\ I\ w] + 
                  1)\);\)\), "\[IndentingNewLine]", 
    \(% /. Exp[I\ z_] \[Rule] Cos[z] + I\ Sin[z] // Simplify\)}], "Input"],

Cell["\<\
Eso es todo lo que se puede conseguir. Definamos la correspondiente soluci\
\[OAcute]n.\
\>", "Text"],

Cell[BoxData[
    \(\(yimag[\[Alpha]_, \[Beta]_, c_, p_]\)[
        t_] := \(\@\[Alpha] + \(\@\(\(-\[Alpha]\) + 4\ c\ \[Beta]\)\ \((\@\(-\
\(\[Alpha]\/\(\[Alpha] - 4\ c\ \[Beta]\)\)\)\ \((\(-1\) + 2\ p\ \[Beta])\)\ \
Cos[1\/2\ t\ \@\(\(-\[Alpha]\)\ \((\[Alpha] - 4\ c\ \[Beta])\)\)] - Sin[1\/2\ \
t\ \@\(\(-\[Alpha]\)\ \((\[Alpha] - 4\ c\ \[Beta])\)\)])\)\)\/\(Cos[1\/2\ t\ \
\@\(\(-\[Alpha]\)\ \((\[Alpha] - 4\ c\ \[Beta])\)\)] + \@\(-\(\[Alpha]\/\(\
\[Alpha] - 4\ c\ \[Beta]\)\)\)\ \((\(-1\) + 2\ p\ \[Beta])\)\ Sin[1\/2\ t\ \@\
\(\(-\[Alpha]\)\ \((\[Alpha] - 4\ c\ \[Beta])\)\)]\)\)\/\(2\ \@\[Alpha]\ \
\[Beta]\) /; \((\[Alpha] - 4\ c\ \[Beta] < 0 || 
            c > \[Alpha]\/\(4\ \[Beta]\))\)\)], "Input"],

Cell[TextData[{
  "En lo que sigue consideraremos que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 8\/100, \ \[Beta] = 1\/1000\)]],
  " (con lo que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\/\(4\ b\) = 20\)]],
  ") y estudiaremos la evoluci\[OAcute]n de la poblaci\[OAcute]n para \
distintos valores de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " y de ",
  Cell[BoxData[
      \(TraditionalForm\`c\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Caso de dos ra\[IAcute]ces reales",
    FontWeight->"Bold"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`c < \[Alpha]\/\(4\ \[Beta]\)\)]],
  ")."
}], "Text"],

Cell[TextData[{
  "Sabemos que siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] > 4  c\ \[Beta]\)]],
  " o, lo que es igual, ",
  Cell[BoxData[
      \(TraditionalForm\`c < \[Alpha]/4  \[Beta]\)]],
  ", hay dos soluciones de equilibrio. Vamos a ver  que la mayor, es asint\
\[OAcute]ticamente estable y la menor es inestable. Las soluciones de \
equilibrio para ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] = 8\/100, \ \[Beta] = 1\/1000, \ 
      c = 15\)]],
  ", vienen dadas por:"
}], "Text"],

Cell[BoxData[{
    \(\({\[Alpha], \[Beta]} = {8\/100, 1\/1000};\)\), "\[IndentingNewLine]", 
    \(soleq[\[Alpha], \[Beta], 15] // Simplify\)}], "Input"],

Cell["La soluci\[OAcute]n correspondiente es.", "Text"],

Cell[BoxData[
    \(\(\(\(yreal[\[Alpha], \[Beta], 15, p]\)[
        t]\)\(//\)\(Simplify\)\(\ \)\)\)], "Input"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`p < 250\)]],
  " la soluci\[OAcute]n ",
  StyleBox["no",
    FontSlant->"Italic"],
  " est\[AAcute] definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0\)]],
  " porque el denominador se anula ",
  StyleBox["pero el numerador se anula antes",
    FontSlant->"Italic"],
  " por lo que la poblaci\[OAcute]n se extingue en un tiempo finito. Si ",
  Cell[BoxData[
      \(TraditionalForm\`p > 250\)]],
  " la soluci\[OAcute]n est\[AAcute] definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0\)]],
  " y se tiene que:"
}], "Text"],

Cell[BoxData[
    \(Limit[%, t \[Rule] \(+\[Infinity]\), 
      Assumptions \[Rule] p > 250]\)], "Input"],

Cell[TextData[{
  "Es decir, la poblaci\[OAcute]n se estabiliza en torno al valor ",
  Cell[BoxData[
      \(TraditionalForm\`y = 750\)]],
  ". Podemos verlo gr\[AAcute]ficamente."
}], "Text"],

Cell[BoxData[{
    \(\(Plot[\(yreal[\[Alpha], \[Beta], 15, 245]\)[t], {t, 0, 
          70}];\)\), "\[IndentingNewLine]", 
    \(\(Plot[\(yreal[\[Alpha], \[Beta], 15, 255]\)[t], {t, 0, 300}, 
        PlotRange \[Rule] All];\)\), "\[IndentingNewLine]", 
    \(\(Plot[\(yreal[\[Alpha], \[Beta], 15, 755]\)[t], {t, 0, 150}, 
        PlotRange \[Rule] All];\)\)}], "Input"],

Cell[TextData[{
  StyleBox["Caso de una ra\[IAcute]z real doble",
    FontWeight->"Bold"],
  " (",
  Cell[BoxData[
      \(TraditionalForm\`c = \[Alpha]\/\(4  \[Beta]\)\)]],
  ")."
}], "Text"],

Cell[TextData[{
  "En este caso hay una \[UAcute]nica soluci\[OAcute]n de equilibrio cuyo \
valor es ",
  Cell[BoxData[
      \(TraditionalForm\`1/2  \[Beta]\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(Clear[\[Alpha], \[Beta]]\), "\[IndentingNewLine]", 
    \(soleq[\[Alpha], \[Beta], \[Alpha]/\((4\ \[Beta])\)] // 
      Simplify\), "\[IndentingNewLine]", 
    \(\({\[Alpha], \[Beta], c} = {8\/100, 
          1\/1000, \[Alpha]\/\(4\ \[Beta]\)};\)\), "\[IndentingNewLine]", 
    \(soleq[\[Alpha], \[Beta], c] // Simplify\)}], "Input"],

Cell["La soluci\[OAcute]n de la ED es:", "Text"],

Cell[BoxData[
    \(\(yreal2[\[Alpha], \[Beta], p]\)[t] // Simplify\)], "Input"],

Cell[TextData[{
  "En este caso, si ",
  Cell[BoxData[
      \(TraditionalForm\`p > 500\)]],
  " la soluci\[OAcute]n est\[AAcute] definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0\)]],
  " y la poblaci\[OAcute]n se estabilizar\[AAcute] asint\[OAcute]ticamente en \
torno a dicho valor:"
}], "Text"],

Cell[BoxData[
    \(Limit[%105, t \[Rule] \(+\[Infinity]\), 
      Assumptions \[Rule] p > 500]\)], "Input"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`p < 500\)]],
  " el denominador se anula en un punto y la soluci\[OAcute]n no est\[AAcute] \
definida para todo ",
  Cell[BoxData[
      \(TraditionalForm\`t \[GreaterEqual] 0\)]],
  ", pero el numerador se anula ",
  StyleBox["antes",
    FontSlant->"Italic"],
  " y los peces se agotar\[AAcute]n en un tiempo finito. Se trata de una \
soluci\[OAcute]n de equilibrio ",
  StyleBox["semiestable",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Show[
        Table[Plot[\(yreal2[\[Alpha], \[Beta], p]\)[t], {t, 0, 40}, 
            DisplayFunction \[Rule] Identity], {p, 250, 750, 50}], 
        DisplayFunction \[Rule] $DisplayFunction];\)\)], "Input"],

Cell[TextData[{
  StyleBox["Caso de ra\[IAcute]ces imaginarias ",
    FontWeight->"Bold"],
  "(",
  Cell[BoxData[
      \(TraditionalForm\`c > \[Alpha]\/\(4  \[Beta]\)\)]],
  ")."
}], "Text"],

Cell[TextData[{
  "Veamos lo que pasa con las soluciones correspondientes a ra\[IAcute]ces \
imaginarias, esto es, ",
  Cell[BoxData[
      \(TraditionalForm\`c > \[Alpha]/4  \[Beta]\)]],
  "."
}], "Text"],

Cell[BoxData[{
    \(Clear[c]\), "\[IndentingNewLine]", 
    \(c /: \ c > 20 := True\), "\[IndentingNewLine]", 
    \(\(\(yimag[\[Alpha], \[Beta], c, p]\)[t] // 
        Simplify;\)\), "\[IndentingNewLine]", 
    \(\(Clear[c];\)\), "\[IndentingNewLine]", 
    \(\(solimag[c_, p_]\)[t_] = FullSimplify[%%, c > 20 && p > 0]\)}], "Input"],

Cell["\<\
En este caso la poblaci\[OAcute]n se extingue siempre en un tiempo finito.\
\>", "Text"],

Cell[BoxData[
    \(\(Plot[\(solimag[21, 1900]\)[t], {t, 0, 100}];\)\)], "Input"],

Cell[TextData[{
  "En resumen, el m\[AAcute]ximo n\[UAcute]mero de peces que se pueden pescar \
viene dado por ",
  Cell[BoxData[
      \(TraditionalForm\`c = \[Alpha]/4  \[Beta]\)]],
  " siempre que la poblaci\[OAcute]n inicial de peces sea mayor que ",
  Cell[BoxData[
      \(TraditionalForm\`1/2  \[Beta]\)]],
  ". Si la poblaci\[OAcute]n inicial de peces es menor que ",
  Cell[BoxData[
      \(TraditionalForm\`1/2  \[Beta]\)]],
  " deber\[AAcute] elegirse ",
  Cell[BoxData[
      \(TraditionalForm\`c < \[Alpha]/4  \[Beta]\)]],
  " con lo cual la poblaci\[OAcute]n crecer\[AAcute] hasta el punto de \
equilibrio:"
}], "Text"],

Cell[BoxData[{
    \(Clear[\[Alpha], \[Beta], c]\), "\[IndentingNewLine]", 
    \(\(soleq[\[Alpha], \[Beta], c]\)[\([1]\)]\)}], "Input"],

Cell[TextData[{
  "el cual es, evidentemente, mayor que ",
  Cell[BoxData[
      \(TraditionalForm\`1/2  \[Beta]\)]],
  ". Cuando la poblaci\[OAcute]n llegue a ser mayor que ",
  Cell[BoxData[
      \(TraditionalForm\`1/2  \[Beta]\)]],
  " podr\[AAcute] establecerse como n\[UAcute]mero de capturas  ",
  Cell[BoxData[
      \(TraditionalForm\`c = \[Alpha]/4  \[Beta]\)]],
  ". "
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Estudio cualitativo de la naturaleza de los puntos cr\[IAcute]ticos de una ED \
aut\[OAcute]noma\
\>", "Section"],

Cell[TextData[{
  "Las EDs del tipo ",
  Cell[BoxData[
      \(TraditionalForm\`y' = f(y)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  " es una funci\[OAcute]n de ua variable definida en un cierto intervalo, se \
llaman EDs ",
  Cell[BoxData[
      FormBox[Cell[TextData[StyleBox["aut\[OAcute]nomas",
          FontWeight->"Bold"]]], TraditionalForm]]],
  ". La ED log\[IAcute]stica es un ejemplo de ellas. Las soluciones de la \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) = 0\)]],
  " se llaman puntos cr\[IAcute]ticos o soluciones de equilibrio de la ED. En \
casos sencillos es posible deducir su naturaleza sin necesidad de resolver la \
ED. Por ejemplo, en la ED log\[IAcute]stica se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) = \[Alpha]\ y\ \((1 - y\/k)\)\)]],
  ", por lo que los puntos cr\[IAcute]ticos son ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  ". Representemos gr\[AAcute]ficamente la curva ",
  Cell[BoxData[
      \(TraditionalForm\`y = f(y)\)]],
  ". "
}], "Text"],

Cell[BoxData[{
    \(<< Graphics`Arrow`\), "\[IndentingNewLine]", 
    \(\(Plot[ .8\ y\ \((1 - y/10)\), {y, 0, 13}, 
        PlotRange \[Rule] {\(- .3\), 2}, 
        AxesLabel \[Rule] {"\<y\>", "\<f(y)\>"}, 
        Epilog \[Rule] {Text["\<k/2\>", {5,  .1}], 
            Text["\<k\>", {10.1,  .1}], Arrow[{ .5,  .1}, {3.5,  .1}], 
            Arrow[{6,  .1}, {9,  .1}], 
            Arrow[{13,  .1}, {11,  .1}]}];\)\)}], "Input"],

Cell[TextData[{
  "Tenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) > 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 < y < k\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) < 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`y > k\)]],
  ". Por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\) > 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`0 < y < k\)]],
  " por lo que las soluciones ser\[AAcute]n crecientes (como funciones de ",
  Cell[BoxData[
      \(TraditionalForm\`t\)]],
  ") cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " est\[EAcute] en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([0, k]\)\)]],
  ". An\[AAcute]logamente, las soluciones ser\[AAcute]n decrecientes para ",
  Cell[BoxData[
      \(TraditionalForm\`y > k\)]],
  ". Las flechas en la gr\[AAcute]fica indican esta situaci\[OAcute]n. \
Deducimos que las soluciones se aproximar\[AAcute]n al valor ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  " y se alejar\[AAcute]n del valor ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  ". Es decir, la soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  " es estable, mientras que ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " es inestable.\nObserva que la situaci\[OAcute]n cambia por completo si \
suponemos que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] < 0\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(Plot[\(- .8\)\ y\ \((1 - y/10)\), {y, 0, 13}, 
        PlotRange \[Rule] { .3, \(-2\)}, 
        AxesLabel \[Rule] {"\<y\>", "\<f(y)\>"}, 
        Epilog \[Rule] {Text["\<k/2\>", {5,  .1}], Text["\<k\>", {9.9,  .1}], 
            Arrow[{3.5,  .1}, { .5,  .1}], Arrow[{9,  .1}, {6,  .1}], 
            Arrow[{11,  .1}, {13,  .1}]}];\)\)], "Input"],

Cell[TextData[{
  "En este caso la soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y = k\)]],
  " es inestable, mientras que ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " es estable (estamos considerando solamente soluciones ",
  StyleBox["positivas",
    FontSlant->"Italic"],
  ", si se permiten soluciones con valores negativos entonces ",
  Cell[BoxData[
      \(TraditionalForm\`y = 0\)]],
  " ser\[IAcute]a un punto de equilibrio inestable). Un estudio \
an\[AAcute]logo puede hacerse para la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' = \[Alpha]\ y\ \((1 - \[Beta]\ y)\) - c\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Un criterio f\[AAcute]cil para decidir la naturaleza de un punto cr\
\[IAcute]tico es el siguiente. Supongamos que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\)\(=\)\(y\_0\)\(\ \)\)\)]],
  "es un punto cr\.b4tico de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' = f(y)\)]],
  ". Es decir ",
  Cell[BoxData[
      \(TraditionalForm\`f(y\_0) = 0\)]],
  ". Entonces, si ",
  Cell[BoxData[
      \(TraditionalForm\`f' \((y\_0)\) < 0\)]],
  " se tendr\[AAcute] que ",
  Cell[BoxData[
      \(TraditionalForm\`f' \((y)\) < 0\)]],
  " en un peque\[NTilde]o intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([y\_0 - \[Delta], y\_0 + \[Delta]\ ]\)\)]],
  " en el cual ",
  Cell[BoxData[
      \(TraditionalForm\`f\)]],
  "ser\[AAcute] decreciente. Por tanto ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) > 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`y - \[Delta] < y < y\_0\)]],
  ", y ",
  Cell[BoxData[
      \(TraditionalForm\`f(y) < 0\)]],
  " para ",
  Cell[BoxData[
      \(TraditionalForm\`y\_0 < y < y\_0 + \[Delta]\)]],
  "; luego ",
  Cell[BoxData[
      \(TraditionalForm\`y' \((t)\)\)]],
  " ser\[AAcute] creciente a la izquierda de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\_0\)\(\ \)\)\)]],
  " y decreciente a la derecha de ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\_0\)\(\ \)\)\)]],
  "por lo que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\_0\)\(\ \)\)\)]],
  "ser\[AAcute] un punto de equilibrio estable. An\[AAcute]logamente, si ",
  Cell[BoxData[
      \(TraditionalForm\`f' \((y\_0)\) > 0\)]],
  " el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y\_0\)\(\ \)\)\)]],
  "ser\[AAcute] un punto de equilibrio inestable."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell["\<\
Supongamos una poblaci\[OAcute]n de peces que, en condiciones naturales, \
responde al modelo log\[IAcute]stico, est\[AAcute] siendo pescada de forma \
proporcional al n\[UAcute]mero de peces que la forman. Es decir, cuanto m\
\[AAcute]s abunda la pesca se pescan m\[AAcute]s. Esto lleva a la ED aut\
\[OAcute]noma siguiente.\
\>", "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`y' \((t)\) = 
      r\ \(y(t)\) \((1 - \ \(y(t)\)\/K)\) - m\ \(y(t)\)\)], "NumberedEquation",\

  TextAlignment->Center,
  FormatType->StandardForm],

Cell[TextData[{
  "Donde, ",
  Cell[BoxData[
      \(TraditionalForm\`r, \ K, \ m\)]],
  " son constantes positivas. El t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm\`m\ \(y(t)\)\)]],
  " es el n\[UAcute]mero de peces pescados por unidad de tiempo.\na) Calcula, \
con la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " (sin usar el comando DSolve[ ]) la soluci\[OAcute]n de la ED (3) que \
verifica ",
  Cell[BoxData[
      \(TraditionalForm\`y(0) = p\)]],
  ". Sugerencia. Usa FullSimplify[ ] para simplificar.\nb) Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`r = 8/100, \ k = 1000, \ m = 1/100\)]],
  " representa algunas curvas soluci\[OAcute]n para distintos valores de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  ".\nc) Prueba que si ",
  Cell[BoxData[
      \(TraditionalForm\`m < r\)]],
  ", entonces hay dos puntos de equilibrio, ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1 = 0\)]],
  ", e ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2 = K(1 - m/r) > 0\)]],
  ". Justifica que ",
  Cell[BoxData[
      \(TraditionalForm\`y\_1\)]],
  " es inestable e ",
  Cell[BoxData[
      \(TraditionalForm\`y\_2\)]],
  " es asint\[OAcute]ticamente estable.\nd) La cantidad ",
  Cell[BoxData[
      \(TraditionalForm\`m\ y\_2\)]],
  " es el n\[UAcute]mero de peces que a largo plazo podr\[AAcute] pescarse. \
Calcula el valor de ",
  Cell[BoxData[
      \(TraditionalForm\`m\)]],
  " que hace m\[AAcute]xima esta cantidad. "
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[BoxData[{
    FormBox[\(Considera\ la\ ED\ aut\[OAcute]noma\), TraditionalForm], "\n", 
    FormBox[
      RowBox[{"\t\t\t\t\t", 
        FormBox[\(\[DifferentialD]y\/\[DifferentialD]t = \((r - s)\) y - 
              a\ y\^3\),
          "TraditionalForm"]}], TraditionalForm], "\[IndentingNewLine]", 
    FormBox[
      RowBox[{"donde", " ", Cell[TextData[Cell[BoxData[
            \(TraditionalForm\`\(\(r\)\(,\)\(\ \)\(s\)\(,\)\(\ \)\(a\)\(\ \
\)\)\)]]]], "son", " ", "constantes", " ", \(\(positivas\)\(.\)\(\ \)\)}], 
      TraditionalForm]}], "NumberedEquation"],

Cell[TextData[{
  "a) Calcula, con la ayuda de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  (sin usar el comando DSolve[ ]) la soluci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(y[r, s, a, p]\)[t]\)\(\ \)\)\)]],
  " de la ED (4) que verifica ",
  Cell[BoxData[
      \(TraditionalForm\`y \((0)\) = p\)]],
  ". Sugerencia. Usa FullSimplify[ ] para simplificar. Adem\[AAcute]s debes \
simplificar tambi\[EAcute]n las ra\[IAcute]ces del denominador. Puedes usar \
para ello una regla como \n\t\tSimplify",
  Cell[BoxData[
      FormBox[
        RowBox[{"[", 
          RowBox[{
            FormBox[
              RowBox[{"%", " ", "/.", 
                FormBox[\(\((1/\((\@x_*\@y_)\))\) \[Rule] \ 1/\@\(x*y\)\),
                  "TraditionalForm"]}],
              "TraditionalForm"], ",", 
            " ", \(a > 0 && r > 0 && s > 0 && p > 0\)}], "]"}], 
        TraditionalForm]]],
  "\nb) Calcula las soluciones de equilibrio seg\[UAcute]n sea ",
  Cell[BoxData[
      \(TraditionalForm\`r < s\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`r > s\)]],
  ". Comprueba que se trata efectivamente de soluciones de equilibrio.\nc) \
Calcula el l\[IAcute]mite de la soluci\[OAcute]n obtenida en el apartado a) \
para ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Rule] \(+\[Infinity]\)\)]],
  ". Debes considerar los casos ",
  Cell[BoxData[
      \(TraditionalForm\`r < s\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`r > s\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`p > 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`r > s\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`p > 0\)]],
  ". Debes simplificar los resultados obtenidos pues deben ser igual a los \
puntos de equilibrio. Sugerencia. Usa el comando Limit[ ] con \
\"Assumptions\". \nd) Representa en una misma gr\[AAcute]fica las \
gr\[AAcute]ficas de las soluciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(y[5, 1, 1, p]\)[t]\)\(\ \)\)\)]],
  " en el intervalo [0,1] para valores de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " desde ",
  Cell[BoxData[
      \(TraditionalForm\`p = \(-5.5\)\)]],
  " hasta ",
  Cell[BoxData[
      \(TraditionalForm\`p = 5.5\)]],
  " con incrementos de 0.5. Representa tambi\[EAcute]n en la misma \
gr\[AAcute]fica con Epilog\[Rule]{Thickness[.007], Line[ ], Line[ ]} las \
soluciones de equilibrio ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(-2\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`y = 2\)]],
  ". Debes usar PlotRange\[Rule]{-5.5,5.5}, AspectRatio\[Rule]1 y con \
PlotStyle representas las gr\[AAcute]ficas para valores negativos de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " en azul, para valores positivos de ",
  Cell[BoxData[
      \(TraditionalForm\`p\)]],
  " en verde y para ",
  Cell[BoxData[
      \(TraditionalForm\`p = 0\)]],
  " en rojo (un comando Which[ ] puede ser \[UAcute]til). Usa DisplayFunction\
\[Rule]Identity para no generar nada m\[AAcute]s que la gr\[AAcute]fica \
final. \ne) Comenta la naturaleza de las soluciones de equilibrio."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Poligonales de Euler", "Section"],

Cell[TextData[{
  "Consideremos una ED de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`y' = f \((x, y)\)\)]],
  ". Podemos representar gr\[AAcute]ficamente las curvas integrales de esta \
ED sin m\[AAcute]s que tener en cuenta que la pendiente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " de una curva integral que pase por  dicho punto tiene que ser igual a ",
  Cell[BoxData[
      \(TraditionalForm\`f(a, b)\)]],
  ". Por tanto, podemos aproximar la gr\[AAcute]fica de dicha curva por una \
poligonal, llamada una poligonal de Euler, cuyos v\[EAcute]rtices vienen \
dados por"
}], "Text"],

Cell[TextData[{
  Cell[BoxData[
      \(TraditionalForm\`\(\((x\_1, y\_1)\) = \((a, b)\);\)\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\((x\_2, y\_2)\) = \((a, b)\) + 
          h\ \((1, f(a, b))\)\/\(\(||\)\((1, f(a, b))\)\(||\)\); \ \((x\_3, 
          y\_3)\) = \((x\_2, y\_2)\) + 
          h \(\(\ \)\((1, f(x\_2, y\_2))\)\)\/\(\(||\)\((1, f(x\_2, \
y\_2))\)\(||\)\)\)\(,\)\(\(.\)\(\ \)\(.\)\(\ \)\(.\)\)\(,\)\(\ \)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\((x\_\(n + 1\), 
          y\_\(n + 1\))\) = \((x\_n, y\_n)\) + 
          h\ \((1, f(x\_n, y\_n))\)\/\(\(||\)\((1, f(x\_n, y\_n))\)\(||\)\)\)\
\)\)]],
  ", . . ."
}], "Text"],

Cell[TextData[{
  "Es decir, nos desplazamos de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)]],
  " al siguiente siguiendo la direcci\[OAcute]n del vector tangente  \
calculado en dicho punto y normalizado, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(\((1, 
                f(x, y))\)\(\ \)\)\/\(\(||\)\((1, f(x, y))\)\(||\)\)\), ",", 
          " ", 
          RowBox[{Cell["y"], "avanzand"}]}], TraditionalForm]]],
  "o una distancia igual a ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(|\)\(h\)\(|\)\)\)]],
  " (",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", Cell[TextData[Cell[BoxData[
              \(TraditionalForm\`h\)]]]]}], TraditionalForm]]],
  " puede ser una cantidad positiva o negativa). Naturalmente, es de esperar \
que cuanto m\[AAcute]s peque\[NTilde]o sea el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " mejor ser\[AAcute] la aproximaci\[OAcute]n obtenida. L\[OAcute]gicamente, \
la gr\[AAcute]fica debe representarse en alg\[UAcute]n intervalo que contenga \
al punto ",
  Cell[BoxData[
      \(TraditionalForm\`a\)]],
  ", digamos ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " con ",
  Cell[BoxData[
      \(TraditionalForm\`c \[LessEqual] a \[LessEqual] d\)]],
  ". La forma de proceder ser\[AAcute] calcular la poligonal a partir del \
punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " hasta llegar al valor de abscisa ",
  Cell[BoxData[
      \(TraditionalForm\`x = c\)]],
  " y unirla apropiadamente a la poligonal que parte de  ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " hasta llegar al valor de abscisa ",
  Cell[BoxData[
      \(TraditionalForm\`x = d\)]],
  ". Para ello dividiremos cada uno de los intervalos [c,a] y [a,d] en ",
  Cell[BoxData[
      \(TraditionalForm\`n\)]],
  " partes de igual longitud, definiremos ",
  Cell[BoxData[
      \(TraditionalForm\`k = \((c - a)\)/n \[LessEqual] \ 0\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`h = \((d - a)\)/n \[GreaterEqual] \ 0\)]],
  " e iteraremos el proceso antes descrito para obtener los puntos de la \
poligonal de Euler."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) Define un comando del tipo poligEuler[f,{a,b},{c,d},n,opts] que \
represente gr\[AAcute]ficamente en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, d]\)\)]],
  " la poligonal de Euler que aproxima la soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' = f(x, y)\)]],
  " que pasa por ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ". La variable n es el n\[UAcute]mero de divisiones que se hacen en cada \
intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([c, a]\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, d]\)\)]],
  " y determina la longitud de los lados de la poligonal, esto es, los \
valores de ",
  Cell[BoxData[
      \(TraditionalForm\`k\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`h\)]],
  " como antes se ha indicado. Es conveniente pasarle a este comando las \
opciones de ListPlot[ ]. Sugerencia: NestList[ ] es el comando apropiado.\nb) \
Considera la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y' = \(f(x, 
            y) = \(2  x + 6  x\^2\)\/\(2  y - 3  y\^2 + 4  y\^3\)\)\)]],
  ". Representa en una misma gr\[AAcute]fica las poligonales de Euler \
poligEuler[f,{-1,1},{-2,2},200]  y poligEuler[f,{-1,-0.682},{-2,2},200]. Usa \
las opciones PlotRange\[Rule]{{-1.5,1.5},{-2,2}}, \
AspectRatio\[Rule]Automatic. \nc) Como se trata de una ED de variables \
separadas puedes indicarle a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " la forma de calcular su soluci\[OAcute]n general. Hazlo y calcula la \
constante que t\[UAcute] deber\[AAcute]s a\[NTilde]adir para obtener la \
soluci\[OAcute]n particular que verifica la condici\[OAcute]n inicial ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(y(\(-1\))\)\(=\)\(1.\)\(\ \ \)\)\)]],
  " Representa, con ImplicitPlot[ ] (debes cargar el correspondiente paquete) \
la soluci\[OAcute]n obtenida que ser\[AAcute] de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y) - c = 0\)]],
  ". Finalmente, muestra juntas en una misma gr\[AAcute]fica la \
gr\[AAcute]fica anterior y la obtenida en el apartado b).\nSugerencia. Debes \
usar DisplayFunction\[Rule]Identity o DisplauyFunction\[Rule]$DisplayFunction \
cuando sea preciso para evitar que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " represente gr\[AAcute]ficas que no deben verse en pantalla."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ecuaciones diferenciales exactas", "Section"],

Cell[TextData[{
  "Te recuerdo que un campo vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(F(x, y)\)\(=\)\((P(x, y), 
          Q(x, y))\)\(\ \)\)\)]],
  ", que suponemos definido en un dominio simplemente conexo del plano, es \
conservativo cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[PartialD]Q\/\[PartialD]x\) \((x, 
            y)\) = \(\[PartialD]P\/\[PartialD]y\) \((x, y)\)\)]],
  " . En tal caso se verifica que hay una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`U(x, y)\)]],
  ", llamada funci\[OAcute]n potencial, \[UAcute]nica salvo constantes \
aditivas, que verifica que ",
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]U\/\[PartialD]x = 
        P, \ \[PartialD]U\/\[PartialD]y = Q\)]],
  " . Cuando esto es as\[IAcute], se dice que la ED ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(x, y)\) \[DifferentialD]x + \ \(Q(x, 
              y)\) \[DifferentialD]y = 0\)]],
  " es exacta. La soluci\[OAcute]n general de dicha ED es la familia de \
curvas definidas impl\[IAcute]citamente por ",
  Cell[BoxData[
      \(TraditionalForm\`U(x, y) = C\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`C\)]],
  " es una constante."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "a) Define un comando que te diga si un campo vectorial de dos variables es \
o no conservativo. La sintaxis de dicho comando debe ser de la forma \
\"conservativoQ[Func]\" donde se supone que \"Func\" es el campo vectorial y \
su salida debe ser \"El campo es conservativo\" o \"El campo no es \
conservativo\".\nComprueba el comando con los campos\na1) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \((6  y\  + \ y\ Exp[x\ y\ ] + 1, 
          6  x + x\ Exp[x\ y])\)\)]],
  ".\na2) ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = \((y\^2\ Exp[x\ y\ ], 
          x\^2\ Exp[x\ y])\)\)]],
  ".\nSugerencia. Para comprobar que dos funciones g[x,y], h[x,y]  son \
iguales es eficaz usar el comando ",
  Cell[BoxData[
      \(TraditionalForm\`Simplify[g[x, y] - h[x, y] == 0] === True\)]],
  ". El comando \"",
  Cell[BoxData[
      \(TraditionalForm\`exp1 === exp2\)]],
  "\" comprueba si las dos expresiones son ",
  StyleBox["id\[EAcute]nticas",
    FontSlant->"Italic"],
  ". La raz\[OAcute]n de esto puedes entenderla con el siguiente ejemplo."
}], "ExerciseText"],

Cell[BoxData[{
    \(Simplify[x \((x + y)\) - x\^2 - x\ y == 0]\  (*\ 
      salida\ True\ *) \), "\n", 
    \(Simplify[
      x \((x + y)\) - x\^2 == 
        0] (*\ \(salida\ que\ no\ es\ True\ y ... \)\ \
\[DownExclamation]tampoco\ \(False!\)\ Por\ eso\ no\ debe\ usarse\ el\ \
comando\  \[Equal] \ 
        como\ control\ boleano\ cuando\ trabajamos\ \(simb\[OAcute]licamente \
: \ porque\ no\ es\ seguro\ que\ siempre\ sea\ False\ o\ True\)\ *) \), "\n", \

    \(Simplify[
      x \((x + y)\) - x\^2 - x\ y === 
        0]\  (*\ \[DownExclamation]salida\ \(False!\)\ Por\ eso\ no\ se\ debe\
\ usar\  === \ 
        como\ control\ boleano\ cuando\ trabajamos\ simb\[OAcute]licamente\ *) \
 (*\ combinando\ los\ dos\ comandos\ se\ puede\ lograr\ algo\ mejor\ que\ \
parece\ que\ funciona\ bien\ *) \), "\[IndentingNewLine]", 
    \(Simplify[x \((x + y)\) - x\^2 == 0] === True\  (*\ salida\ False, \ 
      como\ debe\ ser\ *) \), "\n", 
    \(\(\(Simplify[
        x \((x + y)\) - x\^2 - x\ y == 0]\)\(===\)\(True\)\(\ \)\( (*\ 
        salida\ True, \ como\ debe\ ser\ *) \)\)\)}], "Input"],

Cell[TextData[{
  "b) Define un comando que calcule simb\[OAcute]licamente una \
funci\[OAcute]n potencial de un campo vectorial conservativo de dos \
variables. La sintaxis del comando debe ser de la forma \"potencial[F][x,y]\" \
donde \"F\" es el campo. \nSugerencia. Un comando If[ ] es suficiente. Adem\
\[AAcute]s, para evitar complicaciones, debes usar los comandos Integrate[ ]  \
de la forma Integrate[funcion[x],x] y no de la forma \
Integrate[funcion[x],{x,u,v}]. La expresi\[OAcute]n que vimos en clase para \
calcular la funci\[OAcute]n potencial puede ser \[UAcute]til. Si te parece \
\[UAcute]til, puedes hacer que el potencial calculado se anule en un punto \
que deber\[AAcute]s incluir de forma apropiada como variable del comando, \
aunque esto no es muy necesario y puede hacerse en cada caso concreto.\nb1) \
Comprueba el comando calculando la funci\[OAcute]n potencial del campo ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, 
          y) = \((2  x\ Sin[y], \(x\^2\) Cos[y] - 3  y\^2)\)\)]],
  " que se anula en ",
  Cell[BoxData[
      \(TraditionalForm\`\((0, 0)\)\)]],
  "."
}], "ExerciseText"],

Cell["\<\
c) Usa los comando definidos en los apartados anteriores para lo que sigue. \
Considera la ED\
\>", "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`\((3  x\ y\  + y\^2)\) \[DifferentialD]x + \((x\^2 + 
              x\ y)\) \[DifferentialD]y = 0\)]]], "ExerciseText",
  TextAlignment->Center],

Cell[TextData[{
  "\[DownQuestion]Es exacta? Comprueba que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Mu](x, y) = 
        1\/\(x\ y\ \((2\ x\  + \ y)\)\)\ es\ un\ factor\ integrante\ de\ \
dicha\ ED\ y\ calcula\ su\ soluci\[OAcute]n\ \(\(general\)\(.\)\)\)]],
  " Calcula la soluci\[OAcute]n particular que pasa por (1,1)."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ecuaciones diferenciales lineales", "Section"],

Cell[CellGroupData[{

Cell["\<\
Resoluci\[OAcute]n de una ED lineal homog\[EAcute]nea con coeficientes \
constantes\
\>", "Subsection"],

Cell[TextData[StyleBox["Ra\[IAcute]ces reales simples",
  FontWeight->"Bold"]], "Text"],

Cell["Sea la ED", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y''' - 6  y'' + 11  y' - 6  y = 0\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En la siguiente celda definimos la ecuaci\[OAcute]n, calculamos las ra\
\[IAcute]ces del polinomio caracter\[IAcute]stico, comprobamos si todas son \
distintas, obtenemos la soluci\[OAcute]n general de la ED y la comprobamos. \
Observa lo f\[AAcute]cil que es, cuando no hay ra\[IAcute]ces \
m\[UAcute]ltiples como ocurre en este caso, definir la soluci\[OAcute]n de la \
ED aprovechando que en ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " casi todas las funciones pueden evaluarse en listas."
}], "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(\(eqh[y_, x_] = \(y'''\)[x] - 6 \( y''\)[x] + 11 \( y'\)[x] - 
          6  y[x];\)\), "\[IndentingNewLine]", 
    \(Print["\<Las ra\[IAcute]ces del polinomio caracter\[IAcute]tico \
son:\>"]\), "\[IndentingNewLine]", 
    \(raices = 
      z /. Solve[z^3 - 6  z^2 + 11  z - 6 \[Equal] 0, 
          z]\), "\[IndentingNewLine]", 
    \(Print["\<La soluci\[OAcute]n general de la ED \>", \ 
      eqh[y, x], \ "\<=0 es:\>"]\), "\[IndentingNewLine]", 
    \(solh[x_] = 
      Exp[raices*x] . {C\_1, C\_2, C\_3}\), "\[IndentingNewLine]", 
    \(Print["\<Comprobaci\[OAcute]n.\>"]\), "\[IndentingNewLine]", 
    \(Simplify[eqh[solh, x] \[Equal] 0]\)}], "Input"],

Cell[TextData[StyleBox["Ra\[IAcute]ces reales e imaginarias simples",
  FontWeight->"Bold"]], "Text"],

Cell["\<\
Vamos a ver una forma de obtener la soluci\[OAcute]n para el caso en que haya \
ra\[IAcute]ces imaginarias y reales simples. Consideremos la ED\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y''' - 3  y'' + 4  y' - 2  y = 0\)]]], "Text",
  TextAlignment->Center],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(\(eqh[y_, x_] = \(y'''\)[x] - 3 \( y''\)[x] + 4 \( y'\)[x] - 
          2  y[x];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<Las ra\[IAcute]ces del polinomio caracter\[IAcute]tico \
son:\>"];\)\), "\[IndentingNewLine]", 
    \(raices = 
      z /. Solve[\(-2\) + 4\ z - 3\ z\^2 + z\^3 \[Equal] 0, 
          z]\), "\[IndentingNewLine]", 
    \(\(Print["\<Calculamos las exponenciales.\>"];\)\), \
"\[IndentingNewLine]", 
    \(Exp[raices*x]\), "\[IndentingNewLine]", 
    \(\(Print["\<Formamos las soluciones asociadas a cada \
ra\[IAcute]z.\>"];\)\), "\[IndentingNewLine]", 
    \(ComplexExpand[Re[%%]] // Union\), "\n", 
    \(% /. {Cos[x_] \[Rule] {Cos[x], Sin[x]}, 
          Exp[u_]*Cos[x_] \[Rule] {Exp[u]*Cos[x], Exp[u]*Sin[x]}} // 
      Flatten\), "\[IndentingNewLine]", 
    \(Print["\<La soluci\[OAcute]n general de la ED \>", \ 
      eqh[y, x], \ "\<=0 es:\>"]\), "\[IndentingNewLine]", 
    \(solh[x_] = %% . {C\_1, C\_2, C\_3}\), "\[IndentingNewLine]", 
    \(Print["\<Comprobaci\[OAcute]n.\>"]\), "\[IndentingNewLine]", 
    \(Simplify[eqh[solh, x] \[Equal] 0]\)}], "Input"],

Cell[TextData[StyleBox["Ra\[IAcute]ces m\[UAcute]ltiples reales",
  FontWeight->"Bold"]], "Text"],

Cell["\<\
Consideramos ahora el caso en que hay ra\[IAcute]ces m\[UAcute]ltiples. Sea \
la ED\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y''''' + y'''' - 4  y''' - 4  y'' + 11  y' - 5  y = 
      0\)]]], "Text",
  TextAlignment->Center],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(\(eqh[y_, x_] = \(y'''''\)[x] + \(y''''\)[x] - 4 \( y'''\)[x] - 
          4 \( y''\)[x] + 11 \( y'\)[x] - 
          5  y[x];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<Las ra\[IAcute]ces del polinomio caracter\[IAcute]tico \
son:\>"];\)\), "\[IndentingNewLine]", 
    \(raices = 
      x /. Solve[\(-5\) + 11\ x - 4\ x\^2 - 4\ x\^3 + x\^4 + x\^5 \[Equal] 0, 
          x]\), "\[IndentingNewLine]", 
    \(\(Print["\<Agrupamos las ra\[IAcute]ces\>"];\)\), \
"\[IndentingNewLine]", 
    \(Split[raices]\), "\[IndentingNewLine]", 
    \(\(Print["\<Calculamos las exponenciales\>"];\)\), "\n", 
    \(Exp[%%*x]\), "\n", 
    \(\(Print["\<Tenemos en cuenta las soluciones correspondientes a ra\
\[IAcute]ces m\[UAcute]ltiples\>"];\)\), "\n", 
    \(%% /. z_?VectorQ :> z*Table[x^k, {k, 0, Length[z] - 1}] // 
      Flatten\), "\n", 
    \(\(Print["\<Formamos las soluciones asociadas a cada \
ra\[IAcute]z.\>"];\)\), "\[IndentingNewLine]", 
    \(ComplexExpand[Re[%%]] // Union\), "\n", 
    \(\(Print["\<Completamos la soluci\[OAcute]n\>"];\)\), "\
\[IndentingNewLine]", 
    \(%% /. {Cos[x_] \[Rule] {Cos[x], Sin[x]}, 
          Exp[u_]*Cos[x_] \[Rule] {Exp[u]*Cos[x], Exp[u]*Sin[x]}} // 
      Flatten\), "\n", 
    \(\(Print["\<La soluci\[OAcute]n general de la ED \>", \ 
        eqh[y, x], \ "\<=0 es:\>"];\)\), "\n", 
    \(solh[x_] = {C\_1, C\_2, C\_3, C\_4, C\_5} . %%\), "\n", 
    \(\(Print["\<Comprobaci\[OAcute]n.\>"];\)\), "\n", 
    \(Simplify[eqh[solh, x] \[Equal] 0]\)}], "Input"],

Cell[TextData[StyleBox["Ra\[IAcute]ces reales e imaginarias m\[UAcute]ltiples \
y simples",
  FontWeight->"Bold"]], "Text"],

Cell["Consideremos la ED lineal de orden 11:", "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(32  y[x]\), "-", \(112 \( y'\)[x]\), "+", 
          RowBox[{"184", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"180", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"80", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((4)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"68", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((5)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"174", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((6)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"179", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((7)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"112", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((8)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"44", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((9)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"10", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((10)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((11)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], "=", "0"}], 
      TraditionalForm]], "Text"],

Cell["\<\
Veamos c\[OAcute]mo obtener el polinomio caracter\[IAcute]stico a partir de \
la ED.\
\>", "Text"],

Cell[BoxData[{\(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{\(eq[y_, x_]\), "=", 
        RowBox[{\(32  y[x]\), "-", \(112 \( y'\)[x]\), "+", 
          RowBox[{"184", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"180", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"80", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((4)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"68", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((5)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"174", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((6)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"179", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((7)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"112", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((8)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"44", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((9)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"10", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((10)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((11)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}]}], 
      ";"}], "\[IndentingNewLine]", \(policar[
        x_] = \(eq[y, x] /. \(\(Derivative[k_]\)[y]\)[x] \[Rule] x\^k\) /. 
        y[x] \[Rule] 1\)}], "Input"],

Cell["\<\
Podemos resolver esta ED homog\[EAcute]nea aplicando lo que ya sabemos.\
\>", "Text"],

Cell[BoxData[{\(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    RowBox[{
      RowBox[{
        RowBox[{\(eqh[y_, x_]\), "=", 
          RowBox[{\(32  y[x]\), "-", \(112 \( y'\)[x]\), "+", 
            RowBox[{"184", " ", 
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}]}], "-", 
            RowBox[{"180", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{"80", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((4)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{"68", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((5)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "-", 
            RowBox[{"174", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((6)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{"179", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((7)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "-", 
            RowBox[{"112", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((8)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{"44", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((9)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "-", 
            RowBox[{"10", " ", 
              RowBox[{
                SuperscriptBox["y", 
                  TagBox[\((10)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}]}], "+", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((11)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}]}], ";"}], 
      "\[IndentingNewLine]", \( (*\ 
        puedes\ comprobar\ que\ este\ programa\ funciona\ en\ todos\ los\ \
casos\ eqh[y_, x_] = \(y'''\)[x] - 6 \( y''\)[x] + 11 \( y'\)[x] - 
            6  y[x]\ *) \)}], "\[IndentingNewLine]", \(policar[
          x_] = \(eqh[y, x] /. \(\(Derivative[k_]\)[y]\)[x] \[Rule] x\^k\) /. 
          y[x] \[Rule] 
            1;\), "\[IndentingNewLine]", \(Print["\<Las ra\[IAcute]ces del \
polinomio caracter\[IAcute]tico son:\>"];\), "\[IndentingNewLine]", \(raices \
= x /. Solve[policar[x] \[Equal] 0, 
          x]\), "\[IndentingNewLine]", \(Print["\<Agrupamos las \
ra\[IAcute]ces\>"];\), "\[IndentingNewLine]", \(Split[
      raices]\), "\[IndentingNewLine]", \(Print["\<Calculamos las \
exponenciales\>"];\), "\n", \(Exp[%%*
        x]\), "\n", \(Print["\<Tenemos en cuenta las soluciones \
correspondientes a ra\[IAcute]ces m\[UAcute]ltiples\>"];\), "\n", \(%% /. 
        z_?VectorQ :> z*Table[x^k, {k, 0, Length[z] - 1}] // 
      Flatten\), "\n", \(Print["\<Calculamos la parte real y eliminamos \
elementos repetidos y ordenamos\>"];\), "\[IndentingNewLine]", \
\(ComplexExpand[Re[%%]] // 
      Union\), "\n", \(Print["\<Completamos la soluci\[OAcute]n\>"];\), "\
\[IndentingNewLine]", \(%% /. {Cos[x_] \[Rule] {Cos[x], Sin[x]}, 
          Exp[u_]*Cos[x_] \[Rule] {Exp[u]*Cos[x], Exp[u]*Sin[x]}} // 
      Flatten\), "\n", \(Print["\<La soluci\[OAcute]n general de la ED \>", \ 
        eqh[y, x], \ "\<=0 es:\>"];\), "\n", \(solh[x_] = %% . 
        Table[
          C\_k, {k, 1, 
            Length[raices]}]\), "\n", \
\(Print["\<Comprobaci\[OAcute]n.\>"];\), "\n", \(Simplify[
      eqh[solh, x] \[Equal] 0]\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell["\<\
a) Haz un programa cuya sintaxis debe ser de la forma solGeneral[edl_] cuya \
entrada es una EDL \"edl\" que se supone definida en la forma edl[y,x] como \
en los ejemplos anteriores. El programa debe proporcionar como salida, despu\
\[EAcute]s de comprobar su validez, la soluci\[OAcute]n general de la EDL \
homog\[EAcute]nea \"edl[y,x]=0\". Este programa debe trabajar \
simb\[OAcute]licamente.
b) Usando lo hecho en el apartado anterior, haz un programa cuya sintaxis \
debe ser de la forma solPVI[edl_,ini_] donde \"ini\" es una lista formada por \
las condiciones iniciales. Dicho programa debe proporcionar, despu\[EAcute]s \
de comprobarla, la soluci\[OAcute]n del problema de Cauchy de valores \
iniciales correspondiente. Este programa debe trabajar \
simb\[OAcute]licamente.\
\>", "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["C\[AAcute]lculo de soluciones particulares", "Section"],

Cell[CellGroupData[{

Cell["M\[EAcute]todo de los coeficientes indeterminados", "Subsection"],

Cell["Ejemplo 1", "Example"],

Cell["Calculemos una soluci\[OAcute]n particular de la ED", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y''' - 5  y'' + 8  y' - 4  y = 
      cos \((4  x)\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El t\[EAcute]rmino independiente es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`cos(
          4  x) = \(P(
            x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(cos(\[Beta]\ \
x)\)\)]],
  "  por lo que",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Alpha] = 0, \ \[Beta] = 4, \ 
      P(x) = 1\)\)\)]],
  ". Tenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + \[ImaginaryI]\ \[Beta] = 
        4  \[ImaginaryI]\)]],
  " no es ra\[IAcute]z del polinomio caracter\[IAcute]stico. Buscaremos una \
soluci\[OAcute]n particular de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(y(x)\)\(=\)\),
            "TraditionalForm"], "z", " ", 
          FormBox[\(\[ExponentialE]\^\(4  \[ImaginaryI]\ x\)\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " es una constante que puede tomar valores complejos que calculamos por la \
condici\[OAcute]n de que ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " sea soluci\[OAcute]n de la ED  ",
  Cell[BoxData[
      \(TraditionalForm\`y''' - 5  y'' + 8  y' - 
          4  y = \(\(P(
              x)\) \[ExponentialE]\^\(\((\[Alpha] + \[ImaginaryI]\ \[Beta])\) \
x\) = \[ExponentialE]\^\(4  \[ImaginaryI]\ x\)\)\)]],
  ". Finalmente, la soluci\[OAcute]n que necesitamos ser\[AAcute] la parte \
real de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " "
}], "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(\(eq[y_, x_] := \(y'''\)[x] - 5 \( y''\)[x] + 8 \( y'\)[x] - 
          4  y[x];\)\), "\[IndentingNewLine]", 
    \(\(y[x_] = z*Exp[4\ I\ x];\)\), "\[IndentingNewLine]", 
    \(eq[y, x] // Simplify\)}], "Input"],

Cell[TextData[{
  "Imponemos que ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " sea soluci\[OAcute]n de la ED ",
  Cell[BoxData[
      \(TraditionalForm\`y''' - 5  y'' + 8  y' - 
          4  y = \[ExponentialE]\^\(4  \[ImaginaryI]\ x\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(z = z /. \(Solve[% \[Equal] Exp[4\ I\ x], z]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Una vez obtenido ",
  Cell[BoxData[
      \(TraditionalForm\`z\)]],
  " calculamos la parte real de la soluci\[OAcute]n obtenida y comprobamos el \
resultado."
}], "Text"],

Cell[BoxData[{
    \(h[x_] = ComplexExpand[Re[y[x]]]\), "\[IndentingNewLine]", 
    \(eq[h, x] // Simplify\)}], "Input"],

Cell["Ejemplo 2", "Example"],

Cell["Busquemos ahora una soluci\[OAcute]n particular de la ED", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y'''' - 5  y'' + 8  y' - 4  y = 
      x\ \(sen(x)\)\)]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "El t\[EAcute]rmino independiente es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`sen(
          x) = \(P(
            x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(sen(\[Beta]\ \
x)\)\)]],
  "  por lo que",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Alpha] = 0, \ \[Beta] = 1, \ 
      P(x) = 1\)\)\)]],
  ". Tenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + \[ImaginaryI]\ \[Beta] = \
\[ImaginaryI]\)]],
  " no es ra\[IAcute]z del polinomio caracter\[IAcute]stico. Buscaremos una \
soluci\[OAcute]n particular de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(y(x)\)\(=\)\),
            "TraditionalForm"], \((z + w\ x)\), " ", 
          FormBox[\(\[ExponentialE]\^\(\[ImaginaryI]\ x\)\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`z, \ w\)]],
  " son constantes que pueden tomar valores complejos que calculamos por la \
condici\[OAcute]n de que ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " sea soluci\[OAcute]n de la ED  ",
  Cell[BoxData[
      \(TraditionalForm\`y''' - 5  y'' + 8  y' - 
          4  y = \(\(P(
              x)\) \[ExponentialE]\^\(\((\[Alpha] + \[ImaginaryI]\ \[Beta])\) \
x\) = x\ \[ExponentialE]\^\(\[ImaginaryI]\ x\)\)\)]],
  ". Finalmente, la soluci\[OAcute]n que necesitamos ser\[AAcute] la parte \
imaginaria de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " "
}], "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(\(eq[y_, x_] := \(y'''\)[x] - 5 \( y''\)[x] + 8 \( y'\)[x] - 
          4  y[x];\)\), "\[IndentingNewLine]", 
    \(\(y[x_] = \((z + w\ x)\) Exp[I\ x];\)\), "\[IndentingNewLine]", 
    \(eq[y, x] // Simplify\)}], "Input"],

Cell[TextData[{
  "Observa que siempre que se sustituye en una EDL homog\[EAcute]nea una \
funci\[OAcute]n de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(Q(
          x)\) \[ExponentialE]\^\(\((\[Alpha] + \[ImaginaryI]\ \[Beta])\) x\)\
\)]],
  " podemos sacar factor com\[UAcute]n la funci\[OAcute]n exponencial. Es \
conveniente eliminar esa funci\[OAcute]n para identificat coeficientes."
}], "Text"],

Cell[BoxData[
    \(CoefficientList[Exp[\(-I\)\ x] %, x]\)], "Input"],

Cell[TextData[{
  "Ahora identificamos estos coeficientes con los de ",
  Cell[BoxData[
      \(TraditionalForm\`P(x) = x\)]],
  "."
}], "Text"],

Cell[BoxData[
    \({z, 
        w} = {z, 
          w} /. \(Solve[% \[Equal] {0, 1}, {z, w}]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Una vez obtenidos ",
  Cell[BoxData[
      \(TraditionalForm\`z, \ w\)]],
  " calculamos la parte imaginaria de la soluci\[OAcute]n obtenida y \
comprobamos el resultado."
}], "Text"],

Cell[BoxData[{
    \(h[x_] = ComplexExpand[Im[y[x]]]\), "\[IndentingNewLine]", 
    \(eq[h, x] // Simplify\)}], "Input"],

Cell["Ejemplo 3", "Example"],

Cell["Resolvemos la ED", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y''''' + y'''' - 4  y''' - 4  y'' + 11  y' - 
        5  y = \((1 - x)\)\ \(\[ExponentialE]\^\(\(-2\) x\)\) \(cos(
          x)\)\)]]], "Text",
  TextAlignment->Center],

Cell["Calculamos las ra\[IAcute]ces del polinomio caracter\[IAcute]stico.", \
"Text"],

Cell[BoxData[
    \(x /. Solve[\(-5\) + 11\ x - 4\ x\^2 - 4\ x\^3 + x\^4 + x\^5 \[Equal] 0, 
        x]\)], "Input"],

Cell[TextData[{
  "El t\[EAcute]rmino independiente es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \(\[ExponentialE]\^\(\(-2\) x\)\) \(cos(
            x)\) = \(P(
            x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(cos(\[Beta]\ \
x)\)\)]],
  "  por lo que",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(\[Alpha] = \(-2\), \ \[Beta] = 1, \ 
      P(x) = 1 - x\)\)\)]],
  ". Tenemos que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + \[ImaginaryI]\ \[Beta] = \(-2\) + \
\[ImaginaryI]\)]],
  "  es ra\[IAcute]z simple del polinomio caracter\[IAcute]stico. Buscaremos \
una soluci\[OAcute]n particular de la forma ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(\(y(x)\)\(=\)\),
            "TraditionalForm"], \(x(z + \ w\ x)\), " ", 
          
          FormBox[\(\[ExponentialE]\^\(\((\(-2\)\  + \ \[ImaginaryI])\)\ \
x\)\),
            "TraditionalForm"], " "}], TraditionalForm]]],
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`z, \ w\)]],
  " son constantes que pueden tomar valores complejos que calculamos por la \
condici\[OAcute]n de que ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " sea soluci\[OAcute]n de la ED   ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(y'''' + 5  y'' + 4  y\), "=", 
          RowBox[{\(P(x)\), " ", 
            
            FormBox[\(\[ExponentialE]\^\(\((\(-2\)\  + \ \[ImaginaryI])\)\ \
x\)\),
              "TraditionalForm"]}]}], TraditionalForm]]],
  ". Finalmente, la soluci\[OAcute]n que necesitamos ser\[AAcute] la parte \
real de la funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`y(x)\)]],
  " ."
}], "Text"],

Cell[BoxData[{
    \(Clear["\<@\>"]\), "\[IndentingNewLine]", 
    \(\(eq[y_, x_] = \(y'''''\)[x] + \(y''''\)[x] - 4 \( y'''\)[x] - 
          4 \( y''\)[x] + 11 \( y'\)[x] - 
          5  y[x];\)\), "\[IndentingNewLine]", 
    \(\(y[x_] = 
        x \((z + w\ x)\) 
          Exp[\((\(-2\) + I)\)\ x];\)\), "\[IndentingNewLine]", 
    \(eq[y, x] // Simplify\)}], "Input"],

Cell[BoxData[
    \(CoefficientList[Exp[\((2 - I)\)\ x]*%, x]\)], "Input"],

Cell["Identificamos coeficientes.", "Text"],

Cell[BoxData[
    \({z, 
        w} = {z, 
          w} /. \(Solve[% \[Equal] {1, \(-1\)}, {z, w}]\)[\([1]\)]\)], "Input"],

Cell[TextData[{
  "Una vez obtenidos ",
  Cell[BoxData[
      \(TraditionalForm\`z, \ w\)]],
  " calculamos la parte real de la soluci\[OAcute]n obtenida y comprobamos el \
resultado."
}], "Text"],

Cell[BoxData[{
    \(h[x_] = ComplexExpand[Re[y[x]]]\), "\[IndentingNewLine]", 
    \(eq[h, x] // Simplify\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "a) Haz un programa que calcule una soluci\[OAcute]n particular de una EDL \
con coeficientes constantes cuyo t\[EAcute]rmino independiente es de la forma \
",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\(\[Alpha]\)\(\ \)\(x\)\(\ \)\)\) \(cos(\
\[Beta]\ x)\)\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(sen(\[Beta]\ x)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`P(x)\)]],
  " es una funci\[OAcute]n polin\[OAcute]mica con coeficientes reales. \nEl \
programa debe admitir como entrada una EDL homog\[EAcute]nea y la informaci\
\[OAcute]n necesaria sobre el t\[EAcute]rmino independiente. Su sintaxis \
puede ser de la forma solParticular[edl_,coef_,{\[Alpha]_,\[Beta]_,reim_}] \
donde \"edl\" es la EDL (sin t\[EAcute]rmino independiente), \"coef\" es la \
lista ordenada de coeficientes del polinomio ",
  Cell[BoxData[
      \(TraditionalForm\`P(x)\)]],
  ", \[Alpha] y \[Beta] son los valores correspondientes y \"reim\" es una \
variable que cuando vale 1 quiere decir que hemos de elegir la \
soluci\[OAcute]n real y cuando vale 0 la imaginaria. La salida de este \
programa debe ser una soluci\[OAcute]n particular de la EDL completa \
corrrespondiente. El programa debe comprobar que la soluci\[OAcute]n obtenida \
es correcta antes de mostrarla en pantalla.\nb) Usando el programa del \
apartado anterior, calcula una soluci\[OAcute]n particular de la ED"
}], "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{\(32  y[x]\), "-", \(112 \( y'\)[x]\), "+", 
          RowBox[{"184", " ", 
            RowBox[{
              SuperscriptBox["y", "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"180", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((3)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"80", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((4)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"68", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((5)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"174", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((6)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"179", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((7)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"112", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((8)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{"44", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((9)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "-", 
          RowBox[{"10", " ", 
            RowBox[{
              SuperscriptBox["y", 
                TagBox[\((10)\),
                  Derivative],
                MultilineFunction->None], "[", "x", "]"}]}], "+", 
          RowBox[{
            SuperscriptBox["y", 
              TagBox[\((11)\),
                Derivative],
              MultilineFunction->None], "[", "x", "]"}]}], 
        "=", \(\((\(-1\) + 2  x - 3  x\^2)\)\ \(\[ExponentialE]\^x\) \(sen(
            x)\)\)}], TraditionalForm]], "ExerciseText"],

Cell[TextData[{
  "Sugerencias. Debes obtener el polinomio caracter\[IAcute]stico para \
controlar si ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + I\ \[Beta]\)]],
  " es o no ra\[IAcute]z caracter\[IAcute]stica y, en caso de serlo, obtener \
su multiplicidad. El comando Count[ ] te resuelve ese problema en una l\
\[IAcute]nea pues permite contar el n\[UAcute]mero de veces que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha] + I\ \[Beta]\)]],
  " figura en las ra\[IAcute]ces del polinomio caracter\[IAcute]stico. Si \
este n\[UAcute]mero es m ya puedes formar la funci\[OAcute]n auxiliar \
necesaria y hacer los c\[AAcute]culos oportunos (deber\[AAcute]s introducir \
una lista de constantes c[k]). Finalmente, deber\[AAcute]s definir los dos \
posibles t\[EAcute]rminos independientes que pueden darse, ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\(\[Alpha]\)\(\ \)\(x\)\(\ \)\)\) \(cos(\
\[Beta]\ x)\)\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\[Alpha]\ x\)\) \(sen(\[Beta]\ x)\)\)]],
  ", y definir las soluciones particulares que corresponden a cada uno de \
ellos para elegir la que corresponda en cada caso (un comando Which[ ] puede \
ser \[UAcute]til)."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["M\[EAcute]todo de variaci\[OAcute]n de constantes", "Subsection"],

Cell[TextData[{
  "El m\[EAcute]todo de los coeficientes indeterminados solamente puede \
aplicarse cuando el t\[EAcute]rmino independiente es de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\(\[Alpha]\)\(\ \)\(x\)\(\ \)\)\) \(cos(\
\[Beta]\ x)\)\)]],
  " o ",
  Cell[BoxData[
      \(TraditionalForm\`\(P(
          x)\) \(\[ExponentialE]\^\(\(\[Alpha]\)\(\ \)\(x\)\(\ \)\)\) \(sen(\
\[Beta]\ x)\)\)]],
  " o una suma de ellos. El m\[EAcute]todo que vamos a considerar ahora es m\
\[AAcute]s general porque puede aplicarse siempre. Veamos un ejemplo."
}], "Text"],

Cell["Consideremos la ED", "Text"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y''' - 3  y'' + 4  y' - 
        2  y = \(\[ExponentialE]\^x\) \(tg(x)\)\)]]], "Text",
  TextAlignment->Center],

Cell["\<\
Lo primero que debemos hacer es calcular la soluci\[OAcute]n general de la \
EDL homog\[EAcute]nea correspondiente. Dicha soluci\[OAcute]n es\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(C\_1\) \[ExponentialE]\^x\  + \(C\_2\) \
\[ExponentialE]\^x\ Cos[x]\  + \(\(C\_3\) \(\[ExponentialE]\^x\)\(\ \)\(Sin[
          x]\)\(\ \)\)\)], "Text",
  TextAlignment->Center],

Cell["\<\
En el m\[EAcute]todo de variaci\[OAcute]n de constantes se busca una soluci\
\[OAcute]n particular de la forma\
\>", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(C\_1\)(x)\) \[ExponentialE]\^x\  + \(\(C\_2\)(
          x)\) \[ExponentialE]\^x\ Cos[x]\  + \(\(\(C\_3\)(
          x)\) \(\[ExponentialE]\^x\)\(\ \)\(Sin[x]\)\(\ \)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "donde ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_1\)(x)\)],
    TextAlignment->Center],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_2\)(x)\)],
    TextAlignment->Center],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_3\)(x)\)],
    TextAlignment->Center],
  " son funciones que hay que calcular. Para ello se procede siempre de la \
misma forma."
}], "Text"],

Cell["Definimos una funci\[OAcute]n auxiliar como sigue.", "Text"],

Cell[BoxData[
    \(\(aux[
          x_] = \(a\_1\) Exp[x] + \(a\_2\) Exp[x] Cos[x] + \(a\_3\) Exp[x] 
            Sin[x];\)\)], "Input"],

Cell[TextData[{
  "Estas funciones ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\_1\)(x), \ \(a\_2\)(x), \ \(a\_3\)(x)\)]],
  " ",
  StyleBox["representan las derivadas",
    FontSlant->"Italic"],
  " de las funciones  ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_1\)(x)\)],
    TextAlignment->Center],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_2\)(x)\)],
    TextAlignment->Center],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`\(C\_3\)(x)\)],
    TextAlignment->Center],
  " que queremos calcular. Como no nos interesa que ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " las derive las hemos representado como si fueran constantes. Ahora \
resolvemos el sistema de n ecuaciones (tantas como el orden de la ED) \
lineales en las inc\[OAcute]gnitas ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\_1\)(x), \ \(a\_2\)(x), \ \(a\_3\)(x)\)]],
  " que se obtiene igualando la funci\[OAcute]n \"aux\" y sus derivadas \
sucesivas hasta la de orden n-2 a cero, y la derivada de orden n-1 se iguala \
al t\[EAcute]rmino independiente de la ED. Este sistema permite calcular las \
funciones  ",
  Cell[BoxData[
      \(TraditionalForm\`\(a\_1\)(x), \ \(a\_2\)(x), \ \(a\_3\)(x)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \({a\_1, a\_2, 
        a\_3} /. \(Solve[{aux[x], \(aux'\)[x], \(aux''\)[x]} \[Equal] {0, 0, 
              Exp[x] Tan[x]}, {a\_1, a\_2, a\_3}]\)[\([1]\)]\)], "Input"],

Cell["Ahora calculamos las primitivas de las funciones obtenidas.", "Text"],

Cell[BoxData[
    \(Integrate[%, x]\)], "Input"],

Cell["La soluci\[OAcute]n particular buscada es la siguiente.", "Text"],

Cell[BoxData[
    \(solpart[x_] = % . {Exp[x], Exp[x] Cos[x], Exp[x] Sin[x]} // 
        Simplify\)], "Input"],

Cell["Lo comprobamos sustituyendo esta funci\[OAcute]n en la ED.", "Text"],

Cell[BoxData[{
    \(\(eqd[y_, x_] = \(y'''\)[x] - 3 \( y''\)[x] + 4 \( y'\)[x] - 
          2  y[x];\)\), "\[IndentingNewLine]", 
    \(eqd[solpart, x] // Simplify\)}], "Input"],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell["\<\
Calcula, por el m\[EAcute]todo de variaci\[OAcute]n de constantes, una soluci\
\[OAcute]n particular de la ED.\
\>", "ExerciseText"],

Cell[TextData[Cell[BoxData[
    \(TraditionalForm\`y'' - 2  y' + y = \(\[ExponentialE]\^x\) 
        arctg\ x\)]]], "Text",
  TextAlignment->Center]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowSize->{1016, 651},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
StyleDefinitions -> "Classroom.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 170, 5, 250, "Title"],

Cell[CellGroupData[{
Cell[1949, 60, 39, 0, 93, "Section"],
Cell[1991, 62, 3288, 63, 533, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5316, 130, 50, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[5391, 134, 59, 0, 78, "Subsection"],
Cell[5453, 136, 3406, 85, 353, "Text"],
Cell[8862, 223, 180, 4, 55, "NumberedEquation"],
Cell[9045, 229, 1325, 42, 184, "Text"],
Cell[10373, 273, 143, 3, 61, "Text"],
Cell[10519, 278, 1224, 34, 145, "Text"],
Cell[11746, 314, 430, 8, 205, "Input"],
Cell[12179, 324, 461, 10, 67, "Text"],
Cell[12643, 336, 385, 7, 156, "Input"],
Cell[13031, 345, 147, 5, 41, "Text"],
Cell[13181, 352, 235, 4, 98, "Input"],
Cell[13419, 358, 622, 17, 93, "Text"],
Cell[14044, 377, 142, 2, 72, "Input"],
Cell[14189, 381, 239, 6, 41, "Text"],
Cell[14431, 389, 276, 4, 124, "Input"],
Cell[14710, 395, 294, 5, 124, "Input"],
Cell[15007, 402, 275, 9, 41, "Text"],
Cell[15285, 413, 255, 5, 124, "Input"],
Cell[15543, 420, 822, 26, 93, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16402, 451, 70, 0, 78, "Subsection"],
Cell[16475, 453, 695, 17, 119, "Text"],
Cell[17173, 472, 74, 1, 72, "Input"],
Cell[17250, 475, 326, 7, 67, "Text"],
Cell[17579, 484, 167, 3, 72, "Input"],
Cell[17749, 489, 139, 5, 41, "Text"],
Cell[17891, 496, 174, 3, 72, "Input"],
Cell[18068, 501, 443, 9, 67, "Text"],
Cell[18514, 512, 229, 4, 98, "Input"],
Cell[18746, 518, 380, 12, 67, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19163, 535, 66, 0, 78, "Subsection"],
Cell[19232, 537, 634, 9, 145, "Text"],
Cell[19869, 548, 186, 4, 55, "NumberedEquation"],
Cell[20058, 554, 368, 8, 67, "Text"],
Cell[20429, 564, 169, 3, 61, "Text"],
Cell[20601, 569, 161, 6, 41, "Text"],
Cell[20765, 577, 425, 9, 182, "Input"],
Cell[21193, 588, 242, 6, 67, "Text"],
Cell[21438, 596, 252, 5, 111, "Input"],
Cell[21693, 603, 971, 18, 153, "Text"],
Cell[22667, 623, 109, 2, 98, "Input"],
Cell[22779, 627, 916, 20, 145, "Text"],
Cell[23698, 649, 50, 1, 72, "Input"],
Cell[23751, 652, 655, 15, 93, "Text"],
Cell[24409, 669, 185, 3, 72, "Input"],
Cell[24597, 674, 313, 7, 67, "Text"],
Cell[24913, 683, 450, 9, 176, "Input"],
Cell[25366, 694, 142, 3, 41, "Text"],
Cell[25511, 699, 702, 10, 297, "Input"],
Cell[26216, 711, 395, 11, 75, "Text"],
Cell[26614, 724, 91, 1, 94, "Input"],
Cell[26708, 727, 177, 5, 49, "Text"],
Cell[26888, 734, 104, 2, 94, "Input"],
Cell[26995, 738, 302, 9, 41, "Text"],
Cell[27300, 749, 461, 9, 179, "Input"],
Cell[27764, 760, 105, 3, 41, "Text"],
Cell[27872, 765, 185, 3, 72, "Input"],
Cell[28060, 770, 93, 2, 41, "Text"],
Cell[28156, 774, 409, 8, 124, "Input"],
Cell[28568, 784, 111, 3, 41, "Text"],
Cell[28682, 789, 711, 10, 287, "Input"],
Cell[29396, 801, 453, 15, 73, "Text"],
Cell[29852, 818, 190, 7, 49, "Text"],
Cell[30045, 827, 518, 14, 98, "Text"],
Cell[30566, 843, 153, 2, 124, "Input"],
Cell[30722, 847, 55, 0, 41, "Text"],
Cell[30780, 849, 112, 2, 72, "Input"],
Cell[30895, 853, 651, 20, 67, "Text"],
Cell[31549, 875, 105, 2, 72, "Input"],
Cell[31657, 879, 192, 5, 41, "Text"],
Cell[31852, 886, 369, 6, 124, "Input"],
Cell[32224, 894, 192, 7, 49, "Text"],
Cell[32419, 903, 180, 6, 41, "Text"],
Cell[32602, 911, 354, 6, 182, "Input"],
Cell[32959, 919, 48, 0, 41, "Text"],
Cell[33010, 921, 80, 1, 72, "Input"],
Cell[33093, 924, 331, 9, 67, "Text"],
Cell[33427, 935, 108, 2, 72, "Input"],
Cell[33538, 939, 506, 16, 67, "Text"],
Cell[34047, 957, 230, 4, 98, "Input"],
Cell[34280, 963, 191, 7, 49, "Text"],
Cell[34474, 972, 205, 6, 41, "Text"],
Cell[34682, 980, 335, 6, 176, "Input"],
Cell[35020, 988, 98, 2, 41, "Text"],
Cell[35121, 992, 81, 1, 72, "Input"],
Cell[35205, 995, 633, 16, 93, "Text"],
Cell[35841, 1013, 136, 2, 98, "Input"],
Cell[35980, 1017, 391, 11, 67, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36420, 1034, 123, 3, 93, "Section"],
Cell[36546, 1039, 1118, 31, 124, "Text"],
Cell[37667, 1072, 431, 8, 176, "Input"],
Cell[38101, 1082, 1466, 49, 157, "Text"],
Cell[39570, 1133, 368, 6, 150, "Input"],
Cell[39941, 1141, 637, 18, 93, "Text"],
Cell[40581, 1161, 1728, 54, 145, "Text"],

Cell[CellGroupData[{
Cell[42334, 1219, 31, 0, 68, "Exercise"],
Cell[42368, 1221, 357, 6, 93, "ExerciseText"],
Cell[42728, 1229, 185, 5, 55, "NumberedEquation"],
Cell[42916, 1236, 1500, 44, 255, "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44453, 1285, 31, 0, 68, "Exercise"],
Cell[44487, 1287, 574, 11, 108, "NumberedEquation"],
Cell[45064, 1300, 3109, 86, 471, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[48222, 1392, 39, 0, 93, "Section"],
Cell[48264, 1394, 630, 14, 119, "Text"],
Cell[48897, 1410, 669, 16, 89, "Text"],
Cell[49569, 1428, 2160, 59, 231, "Text"],

Cell[CellGroupData[{
Cell[51754, 1491, 31, 0, 68, "Exercise"],
Cell[51788, 1493, 2375, 54, 437, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[54212, 1553, 51, 0, 93, "Section"],
Cell[54266, 1555, 1204, 30, 161, "Text"],

Cell[CellGroupData[{
Cell[55495, 1589, 31, 0, 68, "Exercise"],
Cell[55529, 1591, 1098, 24, 281, "ExerciseText"],
Cell[56630, 1617, 1096, 22, 385, "Input"],
Cell[57729, 1641, 1121, 20, 265, "ExerciseText"],
Cell[58853, 1663, 125, 3, 41, "ExerciseText"],
Cell[58981, 1668, 195, 3, 36, "ExerciseText"],
Cell[59179, 1673, 347, 7, 75, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59575, 1686, 52, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[59652, 1690, 113, 3, 78, "Subsection"],
Cell[59768, 1695, 87, 1, 41, "Text"],
Cell[59858, 1698, 25, 0, 41, "Text"],
Cell[59886, 1700, 123, 2, 35, "Text"],
Cell[60012, 1704, 538, 10, 119, "Text"],
Cell[60553, 1716, 726, 14, 254, "Input"],
Cell[61282, 1732, 101, 1, 41, "Text"],
Cell[61386, 1735, 167, 3, 41, "Text"],
Cell[61556, 1740, 122, 2, 35, "Text"],
Cell[61681, 1744, 1161, 22, 410, "Input"],
Cell[62845, 1768, 97, 1, 41, "Text"],
Cell[62945, 1771, 107, 3, 41, "Text"],
Cell[63055, 1776, 150, 3, 35, "Text"],
Cell[63208, 1781, 1566, 31, 566, "Input"],
Cell[64777, 1814, 123, 2, 41, "Text"],
Cell[64903, 1818, 54, 0, 41, "Text"],
Cell[64960, 1820, 2225, 61, 66, "Text"],
Cell[67188, 1883, 108, 3, 41, "Text"],
Cell[67299, 1888, 2407, 63, 176, "Input"],
Cell[69709, 1953, 95, 2, 41, "Text"],
Cell[69807, 1957, 4063, 90, 722, "Input"],

Cell[CellGroupData[{
Cell[73895, 2051, 31, 0, 68, "Exercise"],
Cell[73929, 2053, 817, 13, 231, "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[74807, 2073, 61, 0, 93, "Section"],

Cell[CellGroupData[{
Cell[74893, 2077, 71, 0, 78, "Subsection"],
Cell[74967, 2079, 28, 0, 51, "Example"],
Cell[74998, 2081, 67, 0, 41, "Text"],
Cell[75068, 2083, 142, 3, 35, "Text"],
Cell[75213, 2088, 1500, 42, 119, "Text"],
Cell[76716, 2132, 280, 5, 150, "Input"],
Cell[76999, 2139, 267, 9, 41, "Text"],
Cell[77269, 2150, 88, 1, 72, "Input"],
Cell[77360, 2153, 190, 6, 41, "Text"],
Cell[77553, 2161, 120, 2, 98, "Input"],
Cell[77676, 2165, 28, 0, 51, "Example"],
Cell[77707, 2167, 72, 0, 41, "Text"],
Cell[77782, 2169, 142, 3, 35, "Text"],
Cell[77927, 2174, 1505, 42, 145, "Text"],
Cell[79435, 2218, 290, 5, 150, "Input"],
Cell[79728, 2225, 413, 9, 67, "Text"],
Cell[80144, 2236, 69, 1, 72, "Input"],
Cell[80216, 2239, 144, 5, 41, "Text"],
Cell[80363, 2246, 117, 3, 72, "Input"],
Cell[80483, 2251, 202, 6, 41, "Text"],
Cell[80688, 2259, 120, 2, 98, "Input"],
Cell[80811, 2263, 28, 0, 51, "Example"],
Cell[80842, 2265, 32, 0, 41, "Text"],
Cell[80877, 2267, 219, 4, 36, "Text"],
Cell[81099, 2273, 85, 1, 41, "Text"],
Cell[81187, 2276, 116, 2, 73, "Input"],
Cell[81306, 2280, 1647, 47, 145, "Text"],
Cell[82956, 2329, 372, 8, 150, "Input"],
Cell[83331, 2339, 74, 1, 72, "Input"],
Cell[83408, 2342, 43, 0, 41, "Text"],
Cell[83454, 2344, 122, 3, 72, "Input"],
Cell[83579, 2349, 196, 6, 41, "Text"],
Cell[83778, 2357, 120, 2, 98, "Input"],

Cell[CellGroupData[{
Cell[83923, 2363, 31, 0, 68, "Exercise"],
Cell[83957, 2365, 1528, 30, 291, "ExerciseText"],
Cell[85488, 2397, 2313, 62, 66, "ExerciseText"],
Cell[87804, 2461, 1294, 26, 197, "ExerciseText"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89147, 2493, 71, 0, 78, "Subsection"],
Cell[89221, 2495, 613, 14, 93, "Text"],
Cell[89837, 2511, 34, 0, 41, "Text"],
Cell[89874, 2513, 162, 3, 35, "Text"],
Cell[90039, 2518, 165, 3, 41, "Text"],
Cell[90207, 2523, 216, 4, 38, "Text"],
Cell[90426, 2529, 134, 3, 41, "Text"],
Cell[90563, 2534, 246, 4, 38, "Text"],
Cell[90812, 2540, 402, 15, 41, "Text"],
Cell[91217, 2557, 66, 0, 41, "Text"],
Cell[91286, 2559, 137, 3, 72, "Input"],
Cell[91426, 2564, 1225, 34, 145, "Text"],
Cell[92654, 2600, 185, 3, 98, "Input"],
Cell[92842, 2605, 75, 0, 41, "Text"],
Cell[92920, 2607, 48, 1, 72, "Input"],
Cell[92971, 2610, 71, 0, 41, "Text"],
Cell[93045, 2612, 110, 2, 72, "Input"],
Cell[93158, 2616, 74, 0, 41, "Text"],
Cell[93235, 2618, 178, 3, 98, "Input"],

Cell[CellGroupData[{
Cell[93438, 2625, 31, 0, 68, "Exercise"],
Cell[93472, 2627, 142, 3, 41, "ExerciseText"],
Cell[93617, 2632, 148, 3, 35, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

